package choco_aulas;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
//import org.chocosolver.solver.Solution;
import org.chocosolver.solver.variables.IntVar;

public class all_intervals {
	
	public static void main(String[] args) {
		int n = 6;
		Model m = new Model("All Intervals");
		IntVar [] Vars = m.intVarArray("N", n, 1, n);
		IntVar [] Difs = m.intVarArray("D", n-1, 1, n-1);		
		
		m.allDifferent(Vars).post(); 
		/* alternatively
		for(int i = 0; i < n-1; i++){
			for (int j = i+1; j < n; j++){
				m.arithm(Vars[i], "!=", Vars[j]).post();
			}
		}
		*/
		m.allDifferent(Difs).post();
		
		for(int i = 0; i < n-1; i++){
			// Difs[i] = abs(Notes[i+1] - Notes[i]).
			Difs[i].eq(Vars[i+1].sub(Vars[i]).abs()).post();
		}
		
		Solver s = m.getSolver();

		if (s.solve()){
			for(int i = 0; i < n; i++){
				System.out.print(" "+ Vars[i].getValue());
			}
			System.out.println();
			for(int i = 0; i < n-1; i++){
				System.out.print(" " + Difs[i].getValue());
			}
			System.out.println();
		} else {
			System.out.print(" No solutions found");
		}	
		s.printStatistics();
	}
}
