package choco;

import java.io.IOException;
import java.io.FileReader;
import java.io.BufferedReader;


public class graph {
	int [][] dimacs;
	int [][] matriz;
	int nn;
	int ne;
	
	public graph(){ //String file_path){
	}
	
	public void ReadDimacsFormat(String path) throws IOException {
		FileReader fr = new FileReader(path);
		BufferedReader textReader = new BufferedReader(fr);
		String st = textReader.readLine().trim();
		String [] data = st.split(" ");
		nn = Integer.parseInt(data[0]);
		ne = Integer.parseInt(data[1]);
		dimacs = new int [ne+1] [3]; 
		dimacs[0][0]= nn;
		dimacs[0][1]= ne;	
		dimacs[0][2]= 0;
		int i;	
		for (i = 1; i <= ne; i++) {
			data = textReader.readLine().trim().split("\\s+");
			dimacs[i][0]= Integer.parseInt(data[0]);
			dimacs[i][1]= Integer.parseInt(data[1]);
			dimacs[i][2]= Integer.parseInt(data[2]);
		}
		DimacsToMatriz();
		textReader.close();
	}
	
	public void ReadMatrixFormat(String path) throws IOException {
		FileReader fr = new FileReader(path);
		BufferedReader textReader = new BufferedReader(fr);
		String st = textReader.readLine().trim();
		String [] data = st.split(" ");
		nn = Integer.parseInt(data[0]);
		ne = 0;
		matriz = new int [nn][nn]; 
		for (int i = 0; i < nn; i++) {
			String line = textReader.readLine().trim();
			data = line.split("\\s+");
			for (int j = 0; j < nn; j++) {
				int edge = Integer.parseInt(data[j]);
				if (edge > 0) ne = ne+2;
				matriz[i][j]= edge;
			}
		}
		MatrizToDimacs();
		textReader.close();
	}

	public void PrintMatrixFormat() {
		for (int i = 0; i< nn; i++){
			System.out.println();
			for (int j = 0; j< nn; j++){
				System.out.print(" "+ matriz[i][j]);
			}
		}
		System.out.println();
	}
	public void PrintDimacsFormat() {
		for (int i = 0; i<= ne; i++){
			System.out.println();
			for (int j = 0; j< 3; j++){
				System.out.print(" "+ dimacs[i][j]);
			}
		}
		System.out.println();
	}
	public void DimacsToMatriz() {
		matriz = new int [nn][nn]; 
		for (int k = 1; k <= ne; k++){
			int i = dimacs[k][0]-1;
			int j = dimacs[k][1]-1;	
			matriz[i][j] = dimacs[k][2];
			matriz[j][i] = dimacs[k][2];
		}
	}
	
	public void MatrizToDimacs() {
		dimacs = new int [ne+1][3]; 
		dimacs[0][0] = nn;
		dimacs[0][1] = ne;
		dimacs[0][2] = 0;
		int k = 1;
		for (int i = 0; i < nn; i++){
			for (int j = i+1; j < nn; j++){
				if (matriz[i][j] > 0){
					dimacs[k][0] = i+1;
					dimacs[k][1] = j+1;
					dimacs[k][2] = matriz[i][j];
					k = k +1;
				}
			}
		}
	}

}