package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;

public class job_shop {

	public static void main(String[] args) {
				
		// search options
		boolean cumul = true;
		
		Model md = new Model("(" + 4 +"," + 3 + ") - Job Shop");
		Solver sv = md.getSolver();
		int solLimit = 100; sv.limitSolution(solLimit);
		int maxStrt = 20;
		int maxSpan = 30;
		int njobs = 4;
		int ntsks = 3;
		int nmchs = ntsks;
		
		int [][] durs = {{2,4,7},{3,4,5},{5,3,3},{3,4,4}};
		int [][] mchs = {{0,1,2},{2,1,0},{0,1,2},{1,2,0}};
		
		Task [][] tx = new Task[njobs][ntsks];
		for(int i = 0; i < njobs; i++){
			for (int j = 0; j < ntsks; j++){
				tx[i][j] = new Task(md.intVar(1,maxStrt), md.intVar(durs[i][j],durs[i][j]), md.intVar(1, maxSpan));
			}
		}

		Task [][] mx = new Task[nmchs][njobs];
		for (int k = 0; k < nmchs; k++){
			int p = 0;
			for(int i = 0; i < njobs; i++){
				for (int j = 0; j < ntsks; j++){
					if(mchs[i][j] == k){
						mx[k][p] = tx[i][j] ;
						p = p + 1;
					}
				}
			}			
		}

		// precedence constraints
		for (int i = 0; i < njobs; i++) {
			for (int j = 0; j < ntsks-1; j++) {
				md.arithm(tx[i][j].getEnd(), "<=", tx[i][j+1].getStart()).post();
			}
		}
		// makespan is acceptable
		/*
		for (int i = 0; i < njobs; i++) {
			for (int j = 0; j < ntsks; j++) {
				md.arithm(tx[i][j].getEnd(), "<=", maxSpan).post();
			}
		}
		*/
		// set objective 
		IntVar [] lx = md.intVarArray(njobs,1,maxSpan);
		IntVar last = md.intVar(1,maxSpan);
		for (int i = 0; i < njobs; i++)
			lx[i] = tx[i][ntsks-1].getEnd();
		md.max(last, lx).post();
		md.setObjective(Model.MINIMIZE, last);	
		
		if (cumul){
			Cumulative.Filter cum = Cumulative.Filter.SWEEP; //TIME, SWEEP, ...
			boolean graphBased = true;
			IntVar one = md.intVar(1,1);
			IntVar [] ones = md.intVarArray(njobs,1,1);
			for (int k = 0; k < nmchs; k++)
				md.cumulative(mx[k], ones, one, graphBased, cum).post();
		} else {
			for (int k = 0; k < nmchs; k++) {
				for (int i = 0; i < mx[k].length-1; i++) {
					for (int j = i+1; j < mx[k].length; j++) {
						md.or(
							md.arithm(mx[k][i].getEnd(), "<", mx[k][j].getStart()),
							md.arithm(mx[k][j].getEnd(), "<", mx[k][i].getStart())
						).post();
					}
				}
			}
		}
		
		
		
		while (sv.solve()){
			System.out.print("Solving " + sv.getModelName() + " (solution " + sv.getSolutionCount() + ");");
			System.out.println(" with Makespan = " + last.getValue());
			System.out.println("--- Jobs ---");
			for(int i = 0; i< njobs; i++){	
				for (int j = 0; j< ntsks; j++) {
					System.out.print(" " + tx[i][j].getStart().getValue() + " to " + tx[i][j].getEnd().getValue()+"; ");
				}
				System.out.println();
			}
			System.out.println();
			System.out.println("--- Machines ---");
			for(int i = 0; i< nmchs; i++){	
				for (int j = 0; j< ntsks; j++) {
					System.out.print(" " + mx[i][j].getStart().getValue() + " to " + mx[i][j].getEnd().getValue()+"; ");
				}
				System.out.println();
			}
		}
		System.out.println("\n !!! No (more) solutions after " + sv.getTimeCount() + " secs");
	}
}	
	
	/* public Cumulative(Task[] tasks,
                  IntVar[] heights,
                  IntVar capacity,
                  boolean graphBased,
                  Cumulative.Filter... filters)
Cumulative constraint
Parameters:
tasks - task variables (embed start, duration and end variables)
heights - height variables (represent the consumption of each task on the resource)
capacity - maximal capacity of the resource (same at each point in time)
graphBased - parameter indicating how to filter:
-TRUE: applies on subset of overlapping tasks 
- FALSE: applies on all tasks
filters - Filtering algorithm to use: 
- TIME: filters time-table from considering each point in time (efficient in practice as long as the time horizon is not too high) 
- SWEEP: filters time-table with a sweep-based algorithm 
- NRJ: greedy energy-based filter. 
BEWARE: should not be used alone, use it in addition to either SWEEP or TIME.
	 */
		
	/*		
	public static int [] add_element(int elem, int [] vec){
		int n = vec.length;
		int [] vout = new int[n+1];
		for (int i = 0; i < n; i++) vout[i] = vec[i];
		vout[n] = elem;
		return vout;
	};
	*/
