package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.solver.Solver;
import static org.chocosolver.solver.search.strategy.Search.*;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import java.io.IOException;

public class tsp_graph_next {
	
	public static void main(String[] args) throws IOException {
		graph g = new graph();
		g.ReadMatrixFormat("bavaria/bavaria15.txt");
		
		int [][] dist = g.matriz;
		int n = dist.length;
		int maxArcCost = 1000; // it should be the max of the distances 

		
		Model md = new Model(" TSP ");
		Solver s = md.getSolver();
		IntVar [] next = {};
		
		//create the variables and domains
		//a node j belongs to the domain of i if there is an arc from i to j
		for (int i = 0; i < n; i++){
			int [] dom = create_domain(dist[i]);
			IntVar one = md.intVar(dom);
			next = ArrayUtils.concat(next,one);
		}
		System.out.println();

		//int backLimit = 1000; s.limitBacktrack(1000);
		//int solLimit = 15; s.limitSolution(solLimit);
		//int timeLimit = 120000; s.limitTime(timeLimit);
		
		CircuitConf conf = CircuitConf.LIGHT; // ALL, FIRST, LIGHT, RD
		md.circuit(next, 0, conf).post();
		
		//md.circuit(next).post();
		
		s.setSearch(minDomLBSearch(next));
		//s.setSearch(activityBasedSearch(next));
		//s.setSearch(domOverWDegSearch(next));
		
		IntVar cost = md.intVar(1,n*maxArcCost);
		IntVar [] costs = md.intVarArray(n, 0, maxArcCost);
		for(int i = 0; i < n; i++) 
			md.element(costs[i], dist[i], next[i], 0).post();
		md.sum(costs, "=", cost).post();
		md.setObjective(Model.MINIMIZE, cost);	
		
		int k = 0;
		while (s.solve()){
			k = k + 1;
			System.out.print(" Solution " + k + ":\t ");
			for(int i = 0; i< n; i++) {
				System.out.print(" " + next[i].getValue()); 
			}
			System.out.print("\t with cost " + cost.getValue());
			System.out.println("\t in " + s.getTimeCount()*1000 + " ms");
		}
		System.out.println( "\n !!! No (more) solutions in " + s.getTimeCount()*1000 + " ms");
	}
	
	public static int [] create_domain(int [] d){
		int [] dom = {};
		int n = d.length;
		for (int i = 0; i < n; i++){
			if (d[i] > 0){
				int m = dom.length;
				int [] dom_x = new int[m + 1];
				for (int j = 0; j < m; j++){
					dom_x [j] = dom[j];
				}
				dom_x[m] = i;
				dom = dom_x;
			}
		}
		return dom;
	};

}
	