package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;
import static org.chocosolver.solver.search.strategy.Search.*;
import java.io.IOException;

public class tsp_graph_rank {
	
	public static void main(String[] args) throws IOException {
		graph g = new graph();
		g.ReadMatrixFormat("bavaria/bavaria15.txt");
		int [][] distances = g.matriz;
		int n = distances.length;
		int maxArcCost = 1000; // it should be the max of the distances 
		
		Model md = new Model(" TSP ");
		Solver s = md.getSolver();
	
		//create the variables and domains
		IntVar [] rank = md.intVarArray(n,0,n-1);		

		md.allDifferent(rank).post();
		

		// flatten the distances array into a vector d of decision variables
		IntVar [] d = md.intVarArray(n*n,0,maxArcCost);  // No distance is assumed to be above 1000
		int k = 0;
		for (int i = 0; i < n; i++){
			for (int j = 0; j < n; j++){
				md.arithm(d[k], "=", distances[i][j]).post();
				k = k + 1;
			}
		}
		
		IntVar [] costs = md.intVarArray(n,0,maxArcCost);
		for(int i = 0; i < n; i++){
			int j = (i+1) % n;
			IntVar row = md.intVar(0, n*(n-1));
			md.arithm(row, "=", rank[i], "*", n).post();
			IntVar col = md.intVar(0, n-1);	
			md.arithm(col, "=", rank[j]).post();
			IntVar idx = md.intVar(0, n*n-1);
			md.arithm(idx, "=", row, "+", col).post();
			md.element(costs[i], d, idx, 0).post();
		}
			
		IntVar cost = md.intVar(0,n*maxArcCost);	
		md.sum(costs, "=", cost).post();
		
		s.setSearch(minDomLBSearch(rank));
		md.setObjective(Model.MINIMIZE, cost);	
		
		//int backLimit = 1000; s.limitBacktrack(1000);
		//int solLimit = 15; s.limitSolution(solLimit);
		//int timeLimit = 120000; s.limitTime(timeLimit);
		
		
		k = 0;
		while (s.solve()){
			k = k + 1;
			System.out.print(" Solution " + k + ":\t ");
			for(int i = 0; i< n; i++) {
				System.out.print(" " + rank[i].getValue()); 
			}
			System.out.print("\t with cost " + cost.getValue());
			System.out.println("\t in " + s.getTimeCount()*1000 + " ms");
		}
		System.out.println( "\n !!! No (more) solutions in " + s.getTimeCount()*1000 + " ms");
	}
	


}
	