package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;

public class job_schedule {

	public static void main(String[] args) {
				
		int n = 7;
		boolean flexible = true;  // allow flexible tasks 
		
		Model md = new Model("Job Schedule");
		Solver sv = md.getSolver();
		
		int maxT = 5; // 9, 7, 5, 4
		int maxR = 7; // 4, 5, 7, 9

		int [] days = {2 , 4 , 3 , 2 , 1 , 2 , 2};
		int [] wrks = {4 , 1 , 3 , 1 , 2 , 3 , 2};
		//       35 =  8 + 4 + 9 + 2 + 2 + 6 + 4 <= 36 = maxT * maxR 
		
		// set the dimensions of the different tasks
		IntVar [] d = md.intVarArray(n, 1, 100);
		IntVar [] w = md.intVarArray(n, 1, 100);
		if (flexible){
			for(int i = 0; i < n; i++)
				md.arithm(d[i], "*", w[i], "=", days[i]*wrks[i]).post();
		} else {
			for(int i = 0; i < n; i++){
				md.arithm(d[i], "=", days[i]).post();
				md.arithm(w[i], "=", wrks[i]).post();
			}
		}
		
		// specify the different tasks
		Task [] tx = new Task[n];
		for(int i = 0; i < n; i++){
			tx[i] = new Task(md.intVar(1,maxT),d[i], md.intVar(1,maxT+1));
		}

		// set makeSpan 
		IntVar [] lx = md.intVarArray(n,1,maxT+1);
		for (int i = 0; i < n; i++){
			lx[i] = tx[i].getEnd();
		}

		IntVar makeSpan = md.intVar(1,maxT+1);
		md.max(makeSpan, lx).post();

		IntVar maxH = md.intVar(maxR,maxR);
		Cumulative.Filter cum = Cumulative.Filter.SWEEP; //TIME, SWEEP, ... 
		boolean graphBased = true;
		md.cumulative(tx, w, maxH, graphBased, cum).post();

		int solLimit = 3; sv.limitSolution(solLimit);
		
		while (sv.solve()){
			System.out.print("Solving " + sv.getModelName() + " (solution " + sv.getSolutionCount() + ");");
			//System.out.println(" with Makespan = " + makeSpan.getValue());
			System.out.println("--- Start and End Times ---");
			for(int i = 0; i< n; i++){	
				System.out.print(" " + tx[i].getStart().getValue() + " to " + (tx[i].getEnd().getValue()-1)+"; ");
			}
			System.out.println();
		}
		System.out.println("\n !!! No (more) solutions after " + sv.getTimeCount() + " secs");
	}
}	
