package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.exception.ContradictionException;

public class job_schedule_trivial {

	public static void main(String[] args) throws ContradictionException{
		
		Model md = new Model("Job Schedule");
		Solver sv = md.getSolver();

		int [] duration = {2 , 4 , 3 , 1};
		int n = 4;
		
		IntVar [] start = md.intVarArray(n, 1, 11);

		// precedence constraints
		md.arithm(start[1], ">=", start[0], "+", duration[0]).post();
		md.arithm(start[2], ">=", start[0], "+", duration[0]).post();
		md.arithm(start[3], ">=", start[1], "+", duration[1]).post();
		md.arithm(start[1], ">=", start[2], "+", duration[2]).post();
	
		// no overlap constraints disjunction
		/*
		md.or (
			md.arithm(start[2], ">=", start[1], "+", duration[1]),
			md.arithm(start[1], ">=", start[2], "+", duration[2])
		).post();
		*/
		// no overlap constraints cumulative
		IntVar [] strs = new IntVar [] {start[1], start[2]};
		int [] durs = {duration[1], duration[2]};		
		int [] ones = {1,1};
		md.cumulative(strs, durs, ones, 1);
		
		sv.propagate();
		
		for(int i = 0; i < n; i++)
			System.out.println(" LB of start[" + i + "] (# = " + start[i].getDomainSize() + ") = " + start[i].getLB() + ";");
	}
}	
