package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;
import static org.chocosolver.solver.search.strategy.Search.*;

public class y123{
	
	public static void main(String[] args) {

		Model model = new Model(" TSP ");
		Solver s = model.getSolver();
		
		IntVar [] x = model.intVarArray("N", 3, 1, 4);
		model.arithm(x[0], "<=", 2).post();	
		model.arithm(x[1], "<=", 3).post();
		model.arithm(x[2], "<=", 4).post();
		IntVar [] y = model.intVarArray("N", 3, 1, 4);
		for(int i = 0; i < 3; i++) y[2-i] = x[i];
		
		//s.setSearch(inputOrderLBSearch(x)) // left to right
		s.setSearch(inputOrderUBSearch(y), inputOrderLBSearch(x)); // right to left

		
		while (s.solve()){
			System.out.print("-- solution " + s.getSolutionCount() + ":");
			for(int i = 0; i< 3; i++) System.out.print(" " + x[i].getValue()); System.out.println();
		}
		s.printStatistics();
	}
}
	