#include "ibex.h"
#include "vibes.cpp"

using namespace std;
using namespace ibex;

int main() {
	vibes::beginDrawing ();
	vibes::newFigure("example 1");

	// Create the function we want to apply SIVIA on.
	Variable x,y;
	Function f(x,y,sin(x+y)-0.1*x*y);

	// Build the initial box
	IntervalVector box(2);
	box[0]=Interval(-10,10);
	box[1]=Interval(-10,10);

	// Create a stack (for depth-first search)
	stack<IntervalVector> s;

	// Precision (boxes of size less than eps are not processed)
	double eps=0.1;

	// Push the initial box in the stack
	s.push(box);

	Interval z=Interval(0,2);

	while (!s.empty()) {
		IntervalVector box=s.top();
		s.pop();

		Interval fxy=f.eval(box);

		if (fxy.is_subset(z))
			vibes::drawBox(box[0].lb(), box[0].ub(), box[1].lb(), box[1].ub(), "k[g]");
		else if (!fxy.intersects(z))
			vibes::drawBox(box[0].lb(), box[0].ub(), box[1].lb(), box[1].ub(), "k[r]");
		else if (box.max_diam()>eps) {
			// get the index of the dimension of maximal size (false stands for "max")
			int i=box.extr_diam_index(false);
			pair<IntervalVector,IntervalVector> p=box.bisect(i);
			s.push(p.first);
			s.push(p.second);
		}
	}
	vibes::axisAuto();

	vibes::endDrawing();
}
