#include "ibex.h"
#include "vibes.cpp"
#include <iostream>

using namespace std;
using namespace ibex;

int main(int argc, char** argv) {
	vibes::beginDrawing();
	vibes::newFigure("example 2");

// Draw the graphic
	const int nbPts = 1000;
	const double x0 = -4;
	const double x1 = 4;
	const double xStep = (x1-x0)/nbPts;
	std::vector< double > vect_x;
	std::vector< double > vect_g;
	std::vector< double > vect_h;
	for (int i=0; i<nbPts; ++i) {
      const double xi = x0+xStep * i;
      vect_x.push_back(xi);
      vect_g.push_back(pow(xi,2));
      vect_h.push_back(2*xi+4);
	}
	vibes::drawLine(vect_x,vect_g,"black");
	vibes::drawLine(vect_x,vect_h,"black");
	vibes::axisAuto();

// Build the initial box
	IntervalVector box(2);
	box[0]=Interval(-2,2);
	box[1]=Interval(-2,10);
// Draw initial box (black frame)
	//vibes::drawBox(box[0].lb(), box[0].ub(), box[1].lb(), box[1].ub(), "k");

// Define the variables 
	Variable x,y;

// Define Function g(x,y) = sqr(x)-y
	Function g(x,y,sqr(x)-y);
// Define Constraint g(x,y) = 0
	NumConstraint cstr1(g,EQ);
// Define Contractor associated to cstr1
	CtcHC4 c1(cstr1);

// Define Function h(x,y) = 2*x+4-y
	Function h(x,y,2*x+4-y);
// Define Constraint h(x,y) <= 0
	NumConstraint cstr2(h,LEQ);
// Define Contractor associated to cstr2
	CtcHC4 c2(cstr2);

// Define a propagator with the two contractors
	Array<Ctc> ctc(2);
	ctc.set_ref(0,c1);
	ctc.set_ref(1,c2);
	CtcPropag propag(ctc);

// Contract box with the first contractor
	//c1.contract(box);

// Contract box with the second contractor
	//c2.contract(box);

// Contract box with the propagator contractor
	//propag.contract(box);

// Draw resulting box (blue frame)
	//vibes::drawBox(box[0].lb(), box[0].ub(), box[1].lb(), box[1].ub(), "b");

/*
// Split the box
// Get the index of the dimension of maximal size (false stands for "max")
	int i=box.extr_diam_index(false);
	pair<IntervalVector,IntervalVector> p=box.bisect(i);
// Contract the first box with the propagator contractor
	propag.contract(p.first);
// Draw the resulting first box (green frame)
	vibes::drawBox(p.first[0].lb(), p.first[0].ub(), p.first[1].lb(), p.first[1].ub(), "g");
// Contract the first box with the propagator contractor
	propag.contract(p.second);
// Draw the resulting second box (green frame)
	vibes::drawBox(p.second[0].lb(), p.second[0].ub(), p.second[1].lb(), p.second[1].ub(), "g");
*/

	vibes::endDrawing();

}
