#include "ibex.h"
#include "vibes.cpp"
#include <iostream>

using namespace std;
using namespace ibex;

int main(int argc, char** argv) {
	vibes::beginDrawing();
	vibes::newFigure("example 4");

	System sys("satisfaction_problem.txt");
	cout << "**************** Satisfaction Problem ****************" << endl;
	cout << sys << endl;

	DefaultSolver solver(sys,0.1);
 	solver.solve(sys.box);

	IntervalVector box;
	const CovIUList& cov = solver.get_data();
	cout << cov.nb_inner() << " Inner boxes:" << endl;
	for (size_t i=0; i<cov.nb_inner(); i++) {
	  box=cov.inner(i);
	  //cout << "inner n°" << i << " = " << box << endl;	  
	  vibes::drawBox(box[0].lb(),box[0].ub(),box[1].lb(),box[1].ub(), "black[grey]");
	}
	cout << cov.nb_unknown() << " Unknown boxes:" << endl;
	for (size_t i=0; i<cov.nb_unknown(); i++) {
	  box=cov.unknown(i);
	  //cout << "unknown n°" << i << " = " << cov.unknown(i) << endl;
	  vibes::drawBox(box[0].lb(),box[0].ub(),box[1].lb(),box[1].ub(), "black");
	}

	vibes::axisAuto();

	System sysOpt("optimization_problem.txt");
	cout << "**************** Optimization Problem ****************" << endl;
	cout << sysOpt << endl;
	DefaultOptimizer optim(sysOpt,0.1);
	//DefaultOptimizer optim(sysOpt,0.01);
	//DefaultOptimizer optim(sysOpt,0.001);
 	optim.optimize(sysOpt.box);

  	cout << "interval for the minimum: " << Interval(optim.get_uplo(),optim.get_loup()) << endl;
  	cout << "minimizer: " << optim.get_loup_point() << endl;

	vibes::endDrawing();

}
