#include "ibex.h"
#include <iostream>

using namespace std;
using namespace ibex;


void lab2_1() {
	cout << "1. Test the Interval Arithmetic Library" << endl;
	cout << "Consider the intervals I1=[0,1], I2=[2,3] and I3=[-2,-1] and compute:" << endl;
	Interval I1(0,1);
	Interval I2(2,3);
	Interval I3(-2,-1);
	cout << "   a) The left and right bounds of the intervals." << endl;
	cout << "      I1: " << I1 << " left: " << I1.lb() << " right: " << I1.ub() << endl;
	cout << "      I2: " << I2 << " left: " << I1.lb() << " right: " << I1.ub() << endl;
	cout << "      I3: " << I3 << " left: " << I1.lb() << " right: " << I1.ub() << endl;
	cout << "   b) The center and width of the intervals." << endl;
	cout << "      I1: " << I1 << " center: " << I1.mid() << " width: " << I1.diam() << endl;
	cout << "      I2: " << I2 << " center: " << I1.mid() << " width: " << I1.diam() << endl;
	cout << "      I3: " << I3 << " center: " << I1.mid() << " width: " << I1.diam() << endl;
	cout << "   c) I1+I2, I2-I3, I1xI2, I2/I3 and I2/I1." << endl;
	cout << "      I1+I2 = " << (I1+I2) << endl;
	cout << "      I2-I3 = " << (I2-I3) << endl;
	cout << "      I1xI2 = " << (I1*I2) << endl;
	cout << "      I2/I3 = " << (I2/I3) << endl;
	cout << "      I2/I1 = " << (I2/I1) << endl;
	cout << "   d) I1&I2, I1|I2, (I2|I3)&2I1 and I3^3." << endl;
	cout << "      I1&I2 = " << (I1&I2) << endl;
	cout << "      I1|I2 = " << (I1|I2) << endl;
	cout << "      (I2|I3)&2I1 = " << ((I2|I3)&(2*I1)) << endl;
	cout << "      I3^3 = " << (pow(I3,3)) << endl;
	cout << "   e) I1x(I2+I3) and I1xI2+I1xI3." << endl;
	cout << "      I1x(I2+I3) = " << (I1*(I2+I3)) << endl;
	cout << "      I1xI2+I1xI3 = " << (I1*I2+I1*I3) << endl;
	cout << "   f) Let I1=[0.5,1], I2=[2,2.5] and I3=[-2,-1] and compute again e)." << endl;
	I1 = Interval(0.5,1);
	I2 = Interval(2,2.5);
	I3 = Interval(-2,-1);
	cout << "      I1x(I2+I3) = " << (I1*(I2+I3)) << endl;
	cout << "      I1xI2+I1xI3 = " << (I1*I2+I1*I3) << endl;
	cout << endl;
}



void lab2_2() {
	cout << "2. Interval Functions" << endl;
	cout << "Consider the interval expressions X1-X1^2, X1x(1-X1) and 0.25-(X1-0.5)^2." << endl;
	Variable X1("X1");
	Function F1(X1,X1-sqr(X1));
	Function F2(X1,X1*(1-X1));
	Function F3(X1,0.25-sqr(X1-0.5));
	cout << "   F1: " << F1 << endl;
	cout << "   F2: " << F2 << endl;
	cout << "   F3: " << F3 << endl;
	cout << "   a) Evaluate each expression with X1=[0.5,2]." << endl;
	Interval I1(0.5,2);
	cout << "      F1(" << I1 << ") = " << F1.eval(I1) << endl;
	cout << "      F2(" << I1 << ") = " << F2.eval(I1) << endl;
	cout << "      F3(" << I1 << ") = " << F3.eval(I1) << endl;
	cout << "   b) For each expression, evaluate with X1=[0.5,1.25] and with X1=[1.25,2]," << endl;
	cout << "      and compute the union hull of the results." << endl;
	Interval I1a(0.5,1.25);
	Interval I1b(1.25,2);
	cout << "      F1(" << I1a << ") = " << F1.eval(I1a) << endl;
	cout << "      F1(" << I1b << ") = " << F1.eval(I1b) << endl;
	cout << "      F1(" << I1a << ") | F1(" << I1b << ") = " << (F1.eval(I1a)|F1.eval(I1b)) << endl;
	cout << "      F2(" << I1a << ") = " << F2.eval(I1a) << endl;
	cout << "      F2(" << I1b << ") = " << F2.eval(I1b) << endl;
	cout << "      F2(" << I1a << ") | F2(" << I1b << ") = " << (F2.eval(I1a)|F2.eval(I1b)) << endl;
	cout << "      F3(" << I1a << ") = " << F3.eval(I1a) << endl;
	cout << "      F3(" << I1b << ") = " << F3.eval(I1b) << endl;
	cout << "      F3(" << I1a << ") | F3(" << I1b << ") = " << (F3.eval(I1a)|F3.eval(I1b)) << endl;
	cout << endl;
}


void lab2_3() {
	cout << "3. Interval Extensions" << endl;
	cout << "Consider the univariate polynomial function expressed in the standard form as: f(x)=x^3-x^2-x" << endl;
	Variable x("x");
	Function standardF(x,pow(x,3)-sqr(x)-x);
	cout << "   Standard form: " << standardF << endl;
	cout << "   a) Express this function in the Horner form." << endl;
	cout << "      f(x)=x(x^2-x-1)=x(x(x-1)-1)" << endl;
	Function hornerF(x,x*(x*(x-1)-1));
	cout << "      Horner form: " << hornerF << endl;
	cout << "   b) Express this function in the Factored form." << endl;
	cout << "      f(x)=x(x^2-x-1)" << endl;
	cout << "      the roots of x^2-x-1 are: (1+sqrt(5))/2 and (1-sqrt(5))/2" << endl;
	cout << "      f(x)=x*(x-(1+sqrt(5))/2)*(x-(1-sqrt(5))/2)" << endl;
	Function factoredF(x,x*(x-(1+sqrt(5))/2)*(x-(1-sqrt(5))/2));
	cout << "      Factored form: " << factoredF << endl;
	cout << "   c) Compute the enclosure for the range of the function in [-1,1] with each of the 3 forms." << endl;
	cout << "      Which one is tighter?" << endl;
	Interval I(-1,1);
	cout << "      Standard form: f(" << I << ") = " << standardF.eval(I) << " (width: " << standardF.eval(I).diam() << ")" << endl;
	cout << "      Horner form: f(" << I << ") = " << hornerF.eval(I) << " (width: " << hornerF.eval(I).diam() << ")" << endl;
	cout << "      Factored form: f(" << I << ") = " << factoredF.eval(I) << " (width: " << factoredF.eval(I).diam() << ")" << endl;
	cout << "      Standard form is tighter!" << endl;
	cout << "   d) Use the form that produced the tighter enclosure in c) and compute a smaller enclosure based" << endl;
	cout << "      on the subdivision of the previous interval into 4 intervals of width 0.5." << endl;
	Interval Ia(-1,-0.5);
	Interval Ib(-0.5,0);
	Interval Ic(0,0.5);
	Interval Id(0.5,1);
	cout << "      Standard form: f(" << I << ") = f(" << Ia << ") | f(" << Ia << ") | f(" << Ib << ") | f(" << Ic << ") | f(" << Id << ")" << endl;
	cout << "      Standard form: f(" << Ia << ") = " << standardF.eval(Ia) << endl;
	cout << "      Standard form: f(" << Ib << ") = " << standardF.eval(Ib) << endl;
	cout << "      Standard form: f(" << Ic << ") = " << standardF.eval(Ic) << endl;
	cout << "      Standard form: f(" << Id << ") = " << standardF.eval(Id) << endl;
	cout << "      Standard form: f(" << I << ") = " << (standardF.eval(Ia) | standardF.eval(Ib) | standardF.eval(Ic) | standardF.eval(Id)) << endl;
	cout << "   e) Define a function that based on the monotonicity of f computes a sharp enclosure of the range of" << endl;
	cout << "      the function for any interval [a,b]." << endl;
	cout << "      f'(x)=3x^2-2x-1" << endl;
	cout << "      the roots of 3x^2-2x-1 are: -1/3 and 1" << endl;
	cout << "      f([a,b]) -> f([a]) | f([b])  | f([-1/3]) | f([1])" << endl;
	cout << "      f(" << I << ") -> f([" << I.lb() << "]) | f([" << I.ub() << "])  | f([-1/3]) | f([1])" << endl;
	cout << "      f(" << I << ") -> " << (standardF.eval(Interval(I.lb())) | standardF.eval(Interval(I.ub())) | standardF.eval(Interval(-1.0/3.0)) | standardF.eval(Interval(1))) << endl;
	cout << "   f) Define a function that computes an enclosure obtained by the mean value extension of f over" << endl;
	cout << "      any interval [a,b] centered at the midpoint." << endl;
	cout << "      Fc(x) = f(c) + F'([a,b])(x-c)" << endl;
	cout << "      c = (a+b)/2" << endl;
	cout << "      f(c) = c^3-c^2-c" << endl;
	cout << "      F'([a,b]) = 3[a,b]^2-2[a,b]-1" << endl;
	cout << "      Fc(x) = c^3-c^2-c + (3[a,b]^2-2[a,b]-1)(x-c) with c = (a+b)/2" << endl;
	Interval c = Interval(I.mid());
	Interval Fc = pow(c,3)-sqr(c)-c;
	Interval DF = 3*sqr(I)-2*I-1;
	Function meanValueF(x,Fc + DF*(x-c));
	cout << "      Mean value form for [a,b]="<< I <<" : " << meanValueF << endl;
	cout << "      Fc("<< I <<") = " << meanValueF.eval(I) << endl;
	cout << endl;
}

Interval sharpEnclosure(Function f, Interval I0, double precision);

void lab2_4() {
	cout << "4. Sharp enclosure of the range of a real function" << endl;
	cout << "Implement a function that given a generic real function f, an arbitrary interval [a,b] and a precision e," << endl;
	cout << "computes a sharp enclosure of the range of f in [a,b] with the following procedure:" << endl;
	cout << "   a) Computes a sequence of intervals that contain all the zeros of the derivative of f. All the intervals" << endl;
	cout << "   must have the width smaller that the given precision e." << endl;
	cout << "   b) Computes the enclosure of the range of f in [a,b] based on the obtained sequence of intervals." << endl;
	Variable x("x");
	Function standardF(x,pow(x,3)-sqr(x)-x);
	Interval I(-1,1);
	double precision = 0.001;
	Interval S = sharpEnclosure(standardF, I, precision);
	cout << standardF << "(" << I << ") = " << S << " (with precision = " << precision << ")" << endl;

	precision = 0.000001;
	S = sharpEnclosure(standardF, I, precision);
	cout << standardF << "(" << I << ") = " << S << " (with precision = " << precision << ")" << endl;

	I = Interval(-2,2);
	S = sharpEnclosure(standardF, I, precision);
	cout << standardF << "(" << I << ") = " << S << " (with precision = " << precision << ")" << endl;
}

vector<Interval> derivativeZeros(Function f, Interval I0, double precision) {
	vector<Interval> zeros;
	stack<Interval> s;
	Function df = f.diff();
	//cout << "   f: " << f << endl;
	//cout << "   df: " << df << endl;
	s.push(I0);
	while (!s.empty()) {
		Interval I=s.top();
		s.pop();
		Interval dfI = df.eval(I);
		//cout << "--- Pop I = " << I << " dfI " << dfI << endl;
		if (dfI.contains(0.0)) {
			if (I.diam()<=precision) {
				//cout << "--- zero " << I << " (width: " << I.diam() << ")" << endl;
				zeros.push_back(I);
			}
			else {
				pair<Interval,Interval> p=I.bisect();
				//cout << "--- split " << I << " -> " << p.first << " ; " << p.second << endl;
				s.push(p.first);
				s.push(p.second);
			}
		}
		//else cout << "--- delete " << I << endl;
	}
	return zeros;
}

Interval sharpEnclosure(Function f, Interval I0, double precision) {
	vector<Interval> zeros = derivativeZeros(f, I0, precision);
	Interval I = f.eval(Interval(I0.lb()));
	I |= f.eval(Interval(I0.ub()));
	for (int i=0; i<zeros.size(); i++) I |= f.eval(zeros[i]);
	return I;
}
