#include "ibex.h"
#include <iostream>

using namespace std;
using namespace ibex;

vector<Interval> getZeros(Function f, Interval I0) {
	double precision = 0.000001;
	IntervalVector box(1);
	CtcNewton newton(f,I0.diam()); // ibex_CtcNewton.h (to force the application of Newton contract on each box)
	vector<Interval> zeros;
	stack<Interval> s;
	//cout << "--- f: " << f << endl;
	s.push(I0);
	while (!s.empty()) {
		Interval I=s.top();
		s.pop();
		box[0] = I;
		newton.contract(box);
		//cout << "--- Pop I = " << I << " -> " << box[0] << endl;
		if (!box.is_empty()) {
			if (box[0].diam()<=precision) {
				//cout << "--- zero " << box[0] << " (width: " << box[0].diam() << ")" << endl;
				zeros.push_back(box[0]);
			}
			else {
				pair<Interval,Interval> p=box[0].bisect();
				//cout << "--- split " << box[0] << " -> " << p.first << " ; " << p.second << endl;
				s.push(p.first);
				s.push(p.second);
			}
		}
		//else cout << "--- delete " << I << endl;
	}
	return zeros;
}

void lab3_1() {
	cout << "1. Nonlinear Equations" << endl;
	cout << "Apply the interval Newton method to compute enclosures of the zeros of the following equations: " << endl;
	cout << "   a) f(x) = sin(sqrt(x)) - x \t\t with x in [0,1]" << endl;
	Variable x("x");
	Function fa(x,sin(sqrt(x))-x);
	Interval I = Interval(0.0,1.0);
	vector<Interval> za = getZeros(fa, I);
	cout << "   zeros:";
	for (int i=0; i<za.size(); i++) cout << " " << za[i];
	cout << endl;

	cout << "   b) f(x) = -2.75x^3+18x^2-21x-12 \t with x in [-2,6]" << endl;
	Function fb(x,-2.75*pow(x,3)+18*sqr(x)-21*x-12);
	I = Interval(-2,6);
	vector<Interval> zb = getZeros(fb, I);
	cout << "   zeros:";
	for (int i=0; i<zb.size(); i++) cout << " " << zb[i];
	cout << endl;

	cout << "   c) f(x) = sin(10x)+cos(3x) \t with x in [3,6]" << endl;
	Function fc(x,sin(10*x)+cos(3*x));
	I = Interval(3,6);
	vector<Interval> zc = getZeros(fc, I);
	cout << "   zeros:";
	for (int i=0; i<zc.size(); i++) cout << " " << zc[i];
	cout << endl;
	cout << endl;
}


void lab3_2() {
	cout << "2. Interval Linear Systems" << endl;
	cout << "Consider the interval linear system: " << endl;
	cout << "   [2/5,4/5]x1 + x2 = [15/5,17/5]" << endl;
	cout << "   [-4/7,-2/7]x1 + x2 = [23/7,25/7]" << endl;
	cout << "and the initial box [-2.5,2.5]x[1.5,4.5]." << endl;
	cout << "   a) Use the Interval Gauss-Seidel method to solve the system without precontitioning." << endl;
	IntervalMatrix A(2,2);
	A[0][0] = Interval(2.0/5.0,4.0/5.0);
	A[0][1] = Interval(1);
	A[1][0] = Interval(-4.0/7.0,-2.0/7.0);
	A[1][1] = Interval(1);
	IntervalVector b(2);
	b[0] = Interval(15.0/5.0,17.0/5.0);
	b[1] = Interval(23.0/7.0,25.0/7.0);
	IntervalVector box(2);
	box[0] = Interval(-2.5,2.5);
	box[1] = Interval(1.5,4.5);
	cout << "   A = " << A << endl;
	cout << "   b = " << b << endl;
	cout << "   before interval Gauss-Seidel: x = " << box << endl;
	gauss_seidel(A, b, box);  // ibex_Linear.h
	cout << "    after interval Gauss-Seidel: x = " << box << endl;
	cout << "   b) Compute an adequate preconditioner P." << endl;
	Matrix P(2,2);
	P = real_inverse(A.mid());  // ibex_Linear.h
	cout << "   P = " << P << endl;
	cout << "   c) Obtain an equivalent system by applying de above preconditioner P." << endl;
	A = P*A;
	b = P*b;
	cout << "   A = " << A << endl;
	cout << "   b = " << b << endl;
	cout << "   d)	Use the Interval Gauss-Seidel method to solve this new the system." << endl;
	box[0] = Interval(-2.5,2.5);
	box[1] = Interval(1.5,4.5);
	cout << "   before interval Gauss-Seidel: x = " << box << endl;
	gauss_seidel(A, b, box);  // ibex_Linear.h
	cout << "    after interval Gauss-Seidel: x = " << box << endl;
	cout << endl;
}


void lab3_3() {
	cout << "3. Nonlinear Systems of Equations (Pruning)" << endl;
	cout << "Apply the multivariate interval Newton method to solve the following systems: " << endl;
	cout << "   a) x1^2+x1x2=10 ; x2+3x1x2^2=57   with the initial box [1.75,2.25]x[2.75,3.75]. " << endl;
	Variable x1("x1");
	Variable x2("x2");
	Function fa(x1,x2,Return(sqr(x1)+x1*x2-10, x2+3*x1*sqr(x2)-57));
	IntervalVector box(2);
	box[0] = Interval(1.75,2.25);
	box[1] = Interval(2.75,3.75);
	CtcNewton newton_a(fa,box.max_diam());
	cout << "   before interval Newton: x = " << box << endl;
	newton_a.contract(box);
	cout << "    after interval Newton: x = " << box << endl;
	cout << "   b) x^2=5-y^2 ; y+1=x^2   with the initial box [1,3]x[1,3]. " << endl;
	Variable x("x");
	Variable y("y");
	Function fb(x,y,Return(sqr(x)+sqr(y)-5, y+1-sqr(x)));
	box[0] = Interval(1,3);
	box[1] = Interval(1,3);
	CtcNewton newton_b(fb,box.max_diam());
	cout << "   before interval Newton: x = " << box << endl;
	newton_b.contract(box);
	cout << "    after interval Newton: x = " << box << endl;
	cout << endl;
}

vector<IntervalVector> solve(Function f, IntervalVector B0) {
	double precision = 0.000001;
	int n = B0.size();
	IntervalVector box(n);
	CtcNewton newton(f,B0.max_diam()); // ibex_CtcNewton.h (to force the application of Newton contract on each box)
	vector<IntervalVector> solutions;
	stack<IntervalVector> s;
	//cout << "--- f: " << f << endl;
	s.push(B0);
	while (!s.empty()) {
		box=s.top();
		s.pop();
		//cout << "--- Pop I = " << box;
		newton.contract(box);
		//cout << " -> " << box << endl;
		if (!box.is_empty()) {
			if (box.max_diam()<=precision) {
				//cout << "--- zero " << box << " (width: " << box.max_diam() << ")" << endl;
				solutions.push_back(box);
			}
			else {
				int i=box.extr_diam_index(false);
				pair<IntervalVector,IntervalVector> p=box.bisect(i);
				//cout << "--- split " << box << " -> " << p.first << " ; " << p.second << endl;
				s.push(p.first);
				s.push(p.second);
			}
		}
		//else cout << "--- delete " << box << endl;
	}
	return solutions;
}

void lab3_4() {
	cout << "4. Nonlinear Systems of Equations (Solving)" << endl;
	cout << "Compute enclosures for all solutions of the following system within the box [0,4][0,4]:" << endl;
	cout << "   x^2+y^2=10 ; 0.4y-0.1x^2=0" << endl;
	Variable x("x");
	Variable y("y");
	Function f(x,y,Return(sqr(x)+sqr(y)-10, 0.4*y-0.1*sqr(x)));
	IntervalVector box(2);
	box[0] = Interval(0,4);
	box[1] = Interval(0,4);
	vector<IntervalVector> solutions = solve(f, box);
	cout << "   solutions:" ;
	for (int i=0; i<solutions.size(); i++) cout << " " << solutions[i];
	cout << endl;
}
