#include "ibex.h"
#include <iostream>

using namespace std;
using namespace ibex;


void lab4_1() {
	cout << "1. Constraint Decomposition Method" << endl;
	cout << "Consider the constraint y>=(x-7/2)^2-1/4   with x in [0,3], y in [-1,1]:" << endl;
	cout << "   a) Associate primitive narrowing functions to the constraint to narrow the domains of x and y."<< endl;
	cout << "   Primitive constraints:"<< endl;
	cout << "      | y>=(x-7/2)^2-1/4	with x = [0,3], y = [-1,1]"<< endl;
	cout << "   <=>"<< endl;
	cout << "      | y>=z-1/4		with x = [0,3], y = [-1,1], z = [-oo, +oo]"<< endl;
	cout << "      | z=(x-7/2)^2"<< endl;
	cout << "   <=>"<< endl;
	cout << "      | y>=z-1/4		with x = [0,3], y = [-1,1], z = [-oo, +oo], w = [-oo, +oo], v = [-oo, +oo]"<< endl;
	cout << "      | z=w*u"<< endl;
	cout << "      | w=x-7/2"<< endl;
	cout << "      | u=x-7/2"<< endl;
	cout << "   Narrowing functions:"<< endl;
	Variable x("x");
	Variable y("y");
	Variable z("z");
	Variable w("w");
	Variable u("u");
	Function fy_z(z,z-1.0/4.0-Interval(-numeric_limits<double>::infinity(),0.0));
	cout << "      Fy>=z-1/4: " << fy_z << endl;
	Function fz_y(y,y+1.0/4.0+Interval(-numeric_limits<double>::infinity(),0.0));
	cout << "      Fz<=y+1/4: " << fz_y << endl;
	Function fz_wu(w,u,w*u);
	cout << "      Fz=w*u: " << fz_wu << endl;
	Function fw_zu(z,u,z/u);
	cout << "      Fw=z/u: " << fw_zu << endl;
	Function fu_zw(z,w,z/w);
	cout << "      Fu=z/w: " << fu_zw << endl;
	Function fw_x(x,x-7.0/2.0);
	cout << "      Fw=x-7/2: " << fw_x << endl;
	Function fx_w(w,w+7.0/2.0);
	cout << "      Fx=w+7/2: " << fx_w << endl;
	Function fu_x(x,x-7.0/2.0);
	cout << "      Fu=x-7/2: " << fu_x << endl;
	Function fx_u(u,u+7.0/2.0);
	cout << "      Fx=u+7/2: " << fx_u << endl;
	cout << "   b) Compute the fixed-point obtained by the successive application of the above narrowing functions." << endl;
	Interval X(0,3);
	Interval Y(-1,1);
	Interval Z, W, U;

	cout << "   Initial domains:" << " x = " << X << " y = " << Y << " z = " << Z << " w = " << W << " u = " << U << endl;
	Interval newX, newY, newZ, newW, newU;
	IntervalVector V(2);
	bool changed = true;
	while (changed) {
		changed = false;
		newY = Y & fy_z.eval(Z);
		cout << "      Fy>=z-1/4: " << "y <- " << Y << " & " << fy_z.eval(Z) << " = " << newY << endl;
		if (newY!=Y) { changed = true; Y = newY; }
		newZ = Z & fz_y.eval(Y);
		cout << "      Fz<=y+1/4: " << "z <- " << Z << " & " << fz_y.eval(Y) << " = " << newZ << endl;
		if (newZ!=Z) { changed = true; Z = newZ; }
		V[0] = W; V[1] = U;
		newZ = Z & fz_wu.eval(V);
		cout << "      Fz=w*u: " << "z <- " << Z << " & " << fz_wu.eval(V) << " = " << newZ << endl;
		if (newZ!=Z) { changed = true; Z = newZ; }
		V[0] = Z; V[1] = U;
		newW = W & fw_zu.eval(V);
		cout << "      Fw=z/u: " << "w <- " << W << " & " << fw_zu.eval(V) << " = " << newW << endl;
		if (newW!=W) { changed = true; W = newW; }
		V[0] = Z; V[1] = W;
		newU = U & fu_zw.eval(V);
		cout << "      Fu=z/w: " << "u <- " << U << " & " << fu_zw.eval(V) << " = " << newU << endl;
		if (newU!=U) { changed = true; U = newU; }
		newW = W & fw_x.eval(X);
		cout << "      Fw=x-7/2: " << "w <- " << W << " & " << fw_x.eval(X) << " = " << newW << endl;
		if (newW!=W) { changed = true; W = newW; }
		newX = X & fx_w.eval(W);
		cout << "      Fx=w+7/2: " << "x <- " << X << " & " << fx_w.eval(W) << " = " << newX << endl;
		if (newX!=X) { changed = true; X = newX; }
		newU = U & fu_x.eval(X);
		cout << "      Fu=x-7/2: " << "u <- " << U << " & " << fu_x.eval(X) << " = " << newU << endl;
		if (newU!=U) { changed = true; U = newU; }
		newX = X & fx_u.eval(U);
		cout << "      Fx=u+7/2: " << "x <- " << X << " & " << fx_u.eval(U) << " = " << newU << endl;
		if (newX!=X) { changed = true; X = newX; }
		if (changed) cout << "   New domains:";
		else cout << "   Fixed point:";
		cout << " x = " << X << " y = " << Y << " z = " << Z << " w = " << W << " u = " << U << endl;
	}
	cout << endl;
}

Interval narrowBounds(Interval I0, Function f);

void lab4_2() {
	cout << "2. Constraint Newton Method" << endl;
	cout << "Consider the constraint  x^5-3x^3+4x-1=y with x in [0, 0.5], y in [0, 1]. \nUse the constraint Newton method to reduce the domain of x." << endl;
	Variable x("x");
	Variable y("y");
	Interval Iy(0,1);
	Interval Ix(0,0.5);
	//Function fx(x,pow(x,5)-3*pow(x,3)+4*x-1-Iy);
	//cout << "   fx: " << fx << endl;
	//Function fy(y,pow(Ix,5)-3*pow(Ix,3)+4*Ix-1-y);
	//cout << "   fy: " << fy << endl;
	bool changed = true;
	Interval newX, newY;
	cout << "   before constraint Newton method: x = " << Ix << " y = " << Iy << endl;
	while (changed) {
		changed = false;
		Function fx(x,pow(x,5)-3*pow(x,3)+4*x-1-Iy);
		newX = narrowBounds(Ix, fx);
		if (newX!=Ix) {
			changed = true;
			cout << "   x: " << Ix << " -> " << newX << endl;
			Ix = newX;
		}
		Function fy(y,pow(Ix,5)-3*pow(Ix,3)+4*Ix-1-y);
		newY = narrowBounds(Iy, fy);
		if (newY!=Iy) {
			changed = true;
			cout << "   y: " << Iy << " -> " << newY << endl;
			Iy = newY;
		}
	}
	cout << "   after constraint Newton method: x = " << Ix << " y = " << Iy << endl;
	cout << endl;
}

bool intervalProjCond(Interval I, Function f) {
	Interval fI = f.eval(I);
	return fI.contains(0.0);
}

Interval searchLeft(Interval I, Function f) {
	stack<Interval> s;
	Interval I0, I1;
	s.push(I);
	IntervalVector box(1);
	CtcNewton newton(f,I.diam());
	//cout << "--- f: " << f << endl;
	while (!s.empty()) {
		I1=s.top();
		s.pop();
		if (f.eval(I1).contains(0.0)) {
			box[0] = I1;
			newton.contract(box);
			//cout << "--- pop I = " << I1 << " -> " << box[0] << endl;
			if (!box.is_empty()) {
				I1 = box[0];
				I0 = Interval(I1.lb(),next_float(I1.lb()));
				I1 = Interval(next_float(I1.lb()),I1.ub());
				//cout << "--- verify " << I0 << " -> " << f.eval(I0) << endl;
				if (f.eval(I0).contains(0.0)) {
					//cout << "--- zero " << I0 << endl;
					return I0;
				}
				else {
					pair<Interval,Interval> p=I1.bisect();
					//cout << "--- split " << I1 << " -> " << p.second << " ; " << p.first << endl;
					s.push(p.second);
					s.push(p.first);
				}
			}
			//else cout << "--- delete " << I << endl;
		}
	}
	I.set_empty();
	return I;
}

Interval searchRight(Interval I, Function f) {
	stack<Interval> s;
	Interval I0, I1;
	s.push(I);
	IntervalVector box(1);
	CtcNewton newton(f,I.diam());
	//cout << "--- f: " << f << endl;
	while (!s.empty()) {
		I1=s.top();
		s.pop();
		if (f.eval(I1).contains(0.0)) {
			box[0] = I1;
			newton.contract(box);
			//cout << "--- pop I = " << I1 << " -> " << box[0] << endl;
			if (!box.is_empty()) {
				I1 = box[0];
				I0 = Interval(previous_float(I1.ub()),I1.ub());
				I1 = Interval(I1.lb(),previous_float(I1.ub()));
				//cout << "--- verify " << I0 << " -> " << f.eval(I0) << endl;
				if (f.eval(I0).contains(0.0)) {
					//cout << "--- zero " << I0 << endl;
					return I0;
				}
				else {
					pair<Interval,Interval> p=I1.bisect();
					//cout << "--- split " << I1 << " -> " << p.first << " ; " << p.second << endl;
					s.push(p.first);
					s.push(p.second);
				}
			}
			//else cout << "--- delete " << I << endl;
		}
	}
	I.set_empty();
	return I;
}

Interval narrowBounds(Interval I0, Function f) {
	cout << "   --- narrowBounds: " << I0 << " f: " << f << endl;
	Interval I;
	double a = I0.lb();
	double b = I0.ub();
	if (a==b) {
		if (intervalProjCond(I0,f)) return I0;
		I.set_empty();
		return I;
	}
	double aNext = next_float(a);
	if (!intervalProjCond(Interval(a,aNext),f)) {
		I = searchLeft(Interval(aNext,b),f);
		if (I.is_empty()) return I;
		a = I.lb();
	}
	if (a==b) return(Interval(b));
	double bPrev = previous_float(b);
	if (!intervalProjCond(Interval(bPrev,b),f)) {
		I = searchRight(Interval(a,bPrev),f);
		if (I.is_empty()) return I;
		b = I.ub();
	}
	return Interval(a,b);
}


void lab4_3() {
	cout << "3. Revise Procedures" << endl;
	cout << "Consider the constraint  x^5-3x^3+4x-1=y with x in [0, 0.5], y in [0, 1]. \nCompute the box obtained by applying HC4-revise." << endl;
	Variable x("x");
	Variable y("y");
	Function f(x,y,pow(x,5)-3*pow(x,3)+4*x-1-y);
	NumConstraint c(f,EQ);
	cout << "   f: " << f << endl;
	cout << "   c: " << c << endl;
	CtcHC4 hc4(c);
	IntervalVector box(2);
	box[0] = Interval(0,0.5);
	box[1] = Interval(0,1);
	cout << "   before HC4: x = " << box[0] << " y = " << box[1] << endl;
	hc4.contract(box);
	cout << "    after HC4: x = " << box[0] << " y = " << box[1] << endl;
	cout << endl;
}

void lab4_4() {
	cout << "4. Reformulation-Linearization" << endl;
	cout << "Use the reformulation-linearization technique to linearize the following system within the box [0,4]x[0,4]:" << endl;
	cout << "   x^2+y^2=10 ; 0.4y-0.1x^2=0" << endl;
	cout << "   x^2 -> z " << endl;
	cout << "       | L1(z,0) : z >= 2(0)x - 0^2 = 0 " << endl;
	cout << "       | L1(z,4) : z >= 2(4)x - 4^2 = 8x - 16 " << endl;
	cout << "       | L2(z) : z <= (0+4)x - 0*4 = 4x " << endl;
	cout << "   y^2 -> w " << endl;
	cout << "       | L1(w,0) : w >= 2(0)x - 0^2 = 0 " << endl;
	cout << "       | L1(w,4) : w >= 2(4)x - 4^2 = 8x - 16 " << endl;
	cout << "       | L2(w) : w <= (0+4)x - 0*4 = 4x " << endl;
	Variable x("x");
	Variable y("y");
	Variable z("z");
	Variable w("w");
	SystemFactory fac;
	fac.add_var(x);
	fac.add_var(y);
	fac.add_var(z);
	fac.add_var(w);
	fac.add_ctr(z+w = 10);
	fac.add_ctr(0.4*y-0.1*z = 0);
	fac.add_ctr(z >= 0);
	fac.add_ctr(z >= 8*x-16);
	fac.add_ctr(z <= 4*x);
	fac.add_ctr(w >= 0);
	fac.add_ctr(w >= 8*y-16);
	fac.add_ctr(w <= 4*y);
	System sys(fac);
	cout << "   Linear Constraints:" << endl;
	for (int i=0; i<sys.nb_ctr; i++) cout << "      " << sys.ctrs[i] << endl;
	ExtendedSystem sysExtended(sys);
	CtcLinearRelax linear(sysExtended);
	IntervalVector box(4);
	box[0] = Interval(0,4);
	box[1] = Interval(0,4);
	box[2] = Interval(0,16);
	box[3] = Interval(0,16);
	cout << "   before LP: x = " << box[0] << " y = " << box[1] << " z = " << box[2] << " w = " << box[3] << endl;
	linear.contract(box);
	cout << "    after LP: x = " << box[0] << " y = " << box[1] << " z = " << box[2] << " w = " << box[3] << endl;
}
