package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.IntVar;

public class costas {
	
	public static void main(String[] args) {
		int n = 10;
		int k = n * (n-1) / 2;
		Model m = new Model( n + " - Costas Array");
		IntVar[] vars = m.intVarArray("G", n, 1, n);
		IntVar[] jota = m.intVarArray("J", n, 0, n-1);
		IntVar[] dx = m.intVarArray("X", k, -n+1, n-1);
		IntVar[] dy = m.intVarArray("Y", k, -n+1, n-1);
		
		m.allDifferent(vars).post();
		
		// needs to create the array because of the arithm constraint below
		for(int j = 0; j < n; j++){
			m.arithm(jota[j], "=", j).post();
		}
		
		int p = 0;
		for(int i = 0; i < n-1; i++){
			for(int j = i+1; j < n; j++){
				m.arithm(dx[p], "=", vars[j], "-", vars[i]).post();
				m.arithm(dy[p], "=", jota[j], "-", i).post();
				p = p + 1;
			}
		}
		for(int i = 0; i < k-1; i++){
			for(int j = i+1; j < k; j++){
				m.or(
					m.arithm(dx[i], "!=", dx[j]),
					m.arithm(dy[i], "!=", dy[j]))
				.post();
			}
		}		
			
		Solver s = m.getSolver();

		if (s.solve()){
			for(int i  = 0; i < n; i++) 
				System.out.print(" " + vars[i].getValue());
			System.out.println();
			// show that vectors are all different
			for (int i = 0; i < k; i++){
				int x = n*(dy[i].getValue()) + dx[i].getValue();
				System.out.print(" " + x);
			}
			System.out.println();
		} else {
			System.out.println(" No solutions found");
		}
		System.out.println();
		s.printStatistics();			
	}
}
