package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.IntVar;


public class golomb {

	public static void main(String[] args) {
		int n = 8;
		int z = 100;
		int k = n * (n-1) / 2;
		Model m = new Model( "(" + n + "-" + z + ") - Goulomb Ruler");
		IntVar[] vars = m.intVarArray("G", n, 1, z);
		IntVar[] difs = m.intVarArray("D", k, 1, z-1);
		
		for(int i = 0; i < n-1; i++){
			m.arithm(vars[i+1], ">", vars[i]).post();
		}
		
		m.allDifferent(difs).post();
		
		int p = 0;
		for(int i = 0; i < n-1; i++){
			for(int j = i+1; j < n; j++){
				m.arithm(difs[p], "=", vars[j], "-", vars[i]).post();
				p = p + 1;
			}
		}
		
		Solver s = m.getSolver();
		m.setObjective(Model.MINIMIZE, vars[n-1]);
		float t1 = s.getTimeCount()*1000;
		float t2 = s.getTimeCount()*1000;
		while (s.solve()){
			t2 = s.getTimeCount()*1000;
			System.out.println(vars[n-1].getValue());
			for(int i  = 0; i < n; i++) 
				System.out.print(" " + vars[i].getValue());
			System.out.println();
			for(int i  = 0; i < k; i++)
				System.out.print(" " + difs[i].getValue());
			System.out.println();
			System.out.println("cpu time (ms) = " + String.valueOf(s.getTimeCount()*1000));
		}
		float t3 = s.getTimeCount()*1000;
		System.out.println(" No more solutions");
		
		System.out.println("\n");
		System.out.println(" --- Statistics ");
		System.out.println("      number of solutions = " + String.valueOf(s.getSolutionCount()));
		System.out.println("       number of failures = " + String.valueOf(s.getFailCount()));
		System.out.println("     number of backtracks = " + String.valueOf(s.getBackTrackCount()));
		System.out.println("    elapsed cpu time (ms) = " + String.valueOf(s.getTimeCount()*1000));
		System.out.println(" find optim cpu time (ms) = " + String.valueOf(t2-t1));
		System.out.println("check optim cpu time (ms) = " + String.valueOf(t3-t2));
	}
}
