package choco;

/*
 * You are asked to solve the following problem: Find two sequences of 5 two-digit numbers such that
		i. The 10 digits of the 5 two-digit numbers are all different;
		ii. The difference between consecutive numbers in each of the sequences is the same; and
		iii. No number in a sequence appears in the other.
	For example, sequences S1 = <09,27,45,63,81> and S2 = <18,36,54,72,90> are a solution to the problem 
	as in both sequences the difference between consecutive numbers is 18, in none of them a digit appears 
	twice, and no number in a sequence appears in the other.
 */

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;

public class seq_pairing {
	
	public static void main(String[] args) {
		Model m = new Model("Sequence Pairing");
		Solver s = m.getSolver();
		
		IntVar[][] digits = m.intVarMatrix("D", 2, 10, 0, 9);
		IntVar[][] numbrs = m.intVarMatrix("N", 2, 5, 0, 99);
		
		// channelling digits to numbers
		for (int i = 0; i <= 1; i++){
			for(int j = 0; j <= 4; j++) {
				numbrs[i][j].eq(digits[i][2*j+1].mul(10).add(digits[i][2*j])).post();
			}
		}
				
		// digits are all different
		for (int i = 0; i <= 1; i++){
			m.allDifferent(digits[i]).post();
		}
		
		// differences between numbers are the same	
		for (int i = 0; i <= 1; i++){
			for(int j = 1; j < 4; j++) {
				numbrs[i][j+1].sub(numbrs[i][j]).eq(numbrs[i][j].sub(numbrs[i][j-1])).post();
			}
		}
				
		// differences in the two sequences are the same and positive
		(numbrs[0][1].sub(numbrs[0][0])).eq(numbrs[1][1].sub(numbrs[1][0])).post();
		(numbrs[0][1].sub(numbrs[0][0])).gt(0).post();
		
		// solutions are different		
		m.arithm(numbrs[0][1], "<", numbrs[1][1]).post();
		
		// Find no more than 5 different solutions 
		// In fact only 4 solutions are found
		
		s.limitSolution(10);
		
	 	while(s.solve()){
			//System.out.println(solution.toString());
			int d = numbrs[1][1].getValue() - numbrs[1][0].getValue();
			System.out.println("--- Solution found with difference " + d + ":");
			for (int i = 0; i <= 1; i++){
				System.out.print("\t");
				for(int j = 0; j <  5; j++) System.out.print(numbrs[i][j].getValue() + " ");
				System.out.println();
			}
	 	}
		System.out.println("no more solutions sought");
		System.out.println("\n");
		System.out.println(" --- Statistics ");
		System.out.println("      number of solutions = " + String.valueOf(s.getSolutionCount()));
		System.out.println("       number of failures = " + String.valueOf(s.getFailCount()));
		System.out.println("     number of backtracks = " + String.valueOf(s.getBackTrackCount()));
		System.out.println("    elapsed cpu time (ms) = " + String.valueOf(s.getTimeCount()*1000));
	}
}

