package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import static org.chocosolver.solver.search.strategy.Search.minDomLBSearch;

//Langford pairings (n_repeats = 2) exist only when n is congruent to 0 or 3 modulo 4; 
//for instance, there is no Langford pairing when n = 1, 2, or 5.
//for triplets  (n_repeats = 3) there are solutions for 
// n = 26, 27, 28, 35,36,37, 44,45,46, 53,54,55, 62,63,64

// 3 1 2 1 3 2


public class langford {

	public static void main(String[] args) {
		int n_numbers = 26; // 3, 9, 10
		int n_repeats = 3; // 2, 3, 3
		int n = n_numbers*n_repeats;
		Model m = new Model("(" + n_numbers + "," + n_repeats + ")-langford problem");
		IntVar[] lang = m.intVarArray("L", n, 1, n_numbers);
		IntVar[] seed = m.intVarArray("S", n_numbers+1, 0, n-1);
		
		
		
		IntVar[] vals = m.intVarArray("V", n_numbers+1, 1, n_numbers);
		// vals[v] = v; needed for the element constraint below
		for(int v  = 1; v <= n_numbers; v++){
			m.arithm(vals[v], "=", v).post();
		}
		
		// seeds are all different
		m.allDifferent(seed).post();
		
		// seeds must be feasible
		for(int s = 1; s <= n_numbers; s++){
			int max_gap = (s+1) * (n_repeats-1);
			int max_position = n - max_gap;
			m.arithm(seed[s], "<=", max_position).post();
		}

		// lang[seed[i]+offset] = i = vals[i]
		
		/*	seeds: 				0 6 18 15 7 3 8 5 1
			langford numbers:	1 9 1 6 1 8 2 5 7 2 6 9 2 5 8 4 7 6 3 5 4 9 3 8 7 4 3
		 
		    let n_repeats = 3
			for i in 1 to n_numbers: 
				lang[seed[i] + 0*(i+1)] = i
				lang[seed[i] + 1*(i+1)] = i
				lang[seed[i] + 2*(i+1)] = i
				
			for i in 1 to n_numbers:
				for r in 1 to n_repeats:
					lang[seed[i] + (r-1)*(i+1)] = i
		*/			
		// specification with element constraint
		for(int i = 1; i <= n_numbers; i++){
			for(int r = 1; r <= n_repeats; r++){
				int offset = (i+1)*(r-1);
				m.element(vals[i], lang, seed[i], -offset).post();
			}
		}
		
		Solver sv = m.getSolver();
		
		// the seeds determine the problem solution.
		// Hence, only search in the seeds!
		sv.setSearch(minDomLBSearch(seed));
		
		Solution solution = sv.findSolution();
		
		if(solution != null){
			//System.out.println(solution.toString());
			System.out.println("seeds:");
			for (int x = 1; x <= n_numbers; x++)			
				System.out.print(" " + seed[x].getValue());
			System.out.println();
			System.out.println("langford numbers:");
			for (int i = 0; i < n; i++)
				System.out.print(" " + lang[i].getValue());
			System.out.println();
		} else {
			System.out.println("no solutions");
		}
		
		System.out.println();
		System.out.println(" --- Statistics of " + sv.getModelName() + ":");
		System.out.println("       number of failures = " + String.valueOf(sv.getFailCount()));
		System.out.println("     number of backtracks = " + String.valueOf(sv.getBackTrackCount()));
		System.out.println("    elapsed cpu time (ms) = " + String.valueOf(sv.getTimeCount()*1000));
	}
}