package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.*;
import org.chocosolver.solver.Solver;
import org.chocosolver.util.tools.*;
import static org.chocosolver.solver.search.strategy.Search.*;

public class tournament {
	
	public static void main(String[] args) {
		int nt = 8;
		int nw = nt-1;
		int np = nt/2;
		int ns = 2;
		boolean first_fail = true;
		
		Model md = new Model("Round-Robin Tournament (" + nt + ")");
		Solver sv = md.getSolver();
		
		// map[w][p][s]) represents the position in vector team of lot s of period p of week w
		int [][][] map = new int [nw][np][ns];
		int k = 0;
		for (int w= 0; w < nw; w++){
			for (int p= 0; p < np; p++){
				for (int s= 0; s < ns; s++){
					map [w][p][s] = k;
					k = k+1;
				}
			}
		}		
		
		// team(map [w][p][s] represents the team that is in slot s of period p of week w
		IntVar[] teams = md.intVarArray("T", nw*np*ns, 1, nt);
		
		// avoid symmetries in slots
		for (int w= 0; w < nw; w++){
			for (int p = 0; p < np; p++){
				for (int s = 0; s < ns-1; s++){
					md.arithm(teams[map[w][p][s]], "<", teams[map[w][p][s+1]]).post(); 
				}
			}
		}
		
		// every team plays once a week;
		for (int w= 0; w < nw; w++){
			IntVar[] weeks = {};
			for (int p = 0; p < np; p++){
				for (int s = 0; s < ns; s++){
					weeks = ArrayUtils.concat(weeks,teams[map[w][p][s]]);
				}
			}
		md.allDifferent(weeks).post();		
		}		
		//every team plays at most twice in the same period over the tournament;
		for (int p = 0; p < np; p++){
			IntVar[] periods = {};
			for (int w= 0; w < nw; w++){
				for (int s= 0; s < ns; s++){
					periods = ArrayUtils.concat(periods,teams[map[w][p][s]]);
				}		
			}
			for (int t = 1; t <= nt; t++){
				IntVar tc = md.intVar(0, 2);
				md.count(t, periods, tc).post();
			}
		}
		
		//every team plays every other team.
		for (int t1= 1; t1 <nt; t1++){
			for (int t2= t1+1; t2 <=nt; t2++){
				BoolVar [] X = md.boolVarArray(nw*np);
				k = 0;
				for (int w = 0; w <nw; w++){
					for (int p = 0; p <np; p++){
						X[k].eq(teams[map[w][p][0]].eq(t1).and(teams[map[w][p][1]].eq(t2))).post();
						k = k+1;
					}
				}
				md.sum(X, "=", 1).post();
			}
		}


		// first-fail search on teams variables
		
		if (first_fail){
			sv.setSearch(minDomLBSearch(teams));
		}
		
		
		if(sv.solve()){
			show_tournament(teams, map, nw, np, ns);
			show_pairings(teams, map, nw, np, ns);
			show_repeats(teams, map, nw, np, ns);
		} else {
			System.out.print("no solution");
		}
		System.out.println("\n");
		sv.printStatistics();
	}
	
	
	public static void show_tournament(IntVar[] teams, int [][][] map, int nw, int np, int ns){
		for(int p = 0; p < np; p++){ 
			System.out.println();
			for(int w = 0; w < nw; w++){
				for (int s = 0; s < ns; s++)
					System.out.print(teams[map[w][p][s]].getValue());
				System.out.print(" | ");
			}
		}
	}
	
	public static void show_pairings(IntVar[] teams, int [][][] map, int nw, int np, int ns){
		System.out.println('\n');
		for(int t1 = 1; t1 < np*2; t1++){ 
			for(int t2 = t1+1; t2 <= np*2; t2++){ 
			int c = 0;
			for(int w = 0; w < nw; w++){
				for (int p = 0; p < np; p++){
					if ((t1 == teams[map[w][p][0]].getValue()) &
					    (t2 == teams[map[w][p][1]].getValue())) c = c + 1;
				}
			}
			if (c != 1) System.out.println(" no pairing between teams " + t1 + " and " + t2);
			}
		}
		System.out.println(" no (more) missing parents");
	}
	
	public static void show_repeats(IntVar[] teams, int [][][] map, int nw, int np, int ns){
		System.out.println();
		for(int t = 1; t <= np*2; t++){ 
			for(int p = 0; p < np; p++){ 			
				int c = 0;
				for(int w = 0; w < nw; w++){ 
					for(int s = 0; s < ns; s++){
						if (t == teams[map[w][p][s]].getValue()) c = c +1;
					}
				}
				if (c > 2) System.out.println(" two many times " + t + " appears in period " + p);
			}
		}
		System.out.print(" no (more) extra repeats");
	}

}
