package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;
import static org.chocosolver.solver.search.strategy.Search.minDomLBSearch;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;

import java.io.IOException;

public class tsp_aula_next {
	
	public static void main(String[] args) throws IOException {
		
		int [][] dist = { // the adjacency graph of the problem
			{   0, 107, 241, 190, 124,  80, 316,  76, 152, 157, 283, 133, 113, 297, 228},
			{ 107,   0, 148, 137,  88, 127, 336, 183, 134,  95, 254, 180, 101, 234, 175},
			{ 241, 148,   0, 374, 171, 259, 509, 317, 217, 232, 491, 312, 280, 391, 412},
			{ 190, 137, 374,   0, 202, 234, 222, 192, 248,  42, 117, 287,  79, 107,  38},
			{ 124,  88, 171, 202,   0,  61, 392, 202,  46, 160, 319, 112, 163, 322, 240},
			{  80, 127, 259, 234,  61,   0, 386, 141,  72, 167, 351,  55, 157, 331, 272},
			{ 316, 336, 509, 222, 392, 386,   0, 233, 438, 254, 202, 439, 235, 254, 210},
			{  76, 183, 317, 192, 202, 141, 233,   0, 213, 188, 272, 193, 131, 302, 233},
			{ 152, 134, 217, 248,  46,  72, 438, 213,   0, 206, 365,  89, 209, 368, 286},
			{ 157,  95, 232,  42, 160, 167, 254, 188, 206,   0, 159, 22,   57, 149,  80},
			{ 283, 254, 491, 117, 319, 351, 202, 272, 365, 159,   0, 404, 176, 106,  79},
			{ 133, 180, 312, 287, 112,  55, 439, 193,  89, 220, 404,   0, 210, 384, 325},
			{ 113, 101, 280,  79, 163, 157, 235, 131, 209,  57, 176, 210,   0, 186, 117},
			{ 297, 234, 391, 107, 322, 331, 254, 302, 368, 149, 106, 384, 186,   0,  69},
			{ 228, 175, 412,  38, 240, 272, 210, 233, 286,  80,  79, 325, 117,  69,   0}
		};
		
		int n = 15;			// restricts the graph to the first n nodes (n <= 15)
		int max_dist = 800;	// a safe maximum distance between two nodes
		
		// the adjacency matrix of the working graph
		int [][] d = new int [n][n];	 
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++)
				d[i][j] = dist[i][j];
				
		Model md = new Model(" TSP ");
		Solver sv = md.getSolver();
		
		// Decision vector representing the next node of each node in the circuit
		// next = [ 3 0 4 2 1] => circuit = 2->4->1->0->3->2 
		// equivalent to:
		// rank = [ 2 4 1 0 3] => circuit = 2->4->1->0->3->2		
		IntVar [] next = md.intVarArray("rank", n, 0, n-1);
		
		// A solution is a circuit defined on the next deciion variables
		CircuitConf conf = CircuitConf.LIGHT; // ALL, FIRST, LIGHT, RD
		md.circuit(next, 0, conf).post();
		
		// cost[i] denotes the distance of the arc leaving node i
		IntVar [] cost = md.intVarArray("cost", n, 0, max_dist);
		
		// cost[i] = d[i][next[i]]
		for (int i = 0; i < n; i++) md.element(cost[i], d[i], next[i], 0).post();
		
		// total_cost is the sum of all costs
		IntVar tot_cost = md.intVar(0, n*max_dist);	
		md.sum(cost, "=", tot_cost).post();
	
		// minimise an objective function; here is the total cost
		md.setObjective(Model.MINIMIZE, tot_cost);	
		
		// heuristic search: prefer
		//    variables with less values in their domain
		//    assign them, their lower bounds
		sv.setSearch(minDomLBSearch(next));	
		
		// set search interruption parameters
		// int backLimit = 1000; sv.limitBacktrack(1000);
		// int solLimit = 3; sv.limitSolution(solLimit);
		// int timeLimit = 120000; sv.limitTime(timeLimit);
		
		while (sv.solve()){
			System.out.print("\n -- solution " + sv.getSolutionCount() + "\t= " + tot_cost.getValue());
			System.out.println(" found after " + sv.getTimeCount() + " secs");
			for(int i = 0; i< n; i++) System.out.print(" " + next[i].getValue()); System.out.println();
			//for(int i = 0; i< n; i++) System.out.print(" " + rk_2[i].getValue()); System.out.println();
			//for(int i = 0; i< n; i++) System.out.print(" " + cost[i].getValue()); System.out.println();
		}
		System.out.print( "\n !!! No (more) solutions");
		System.out.println(" after " + sv.getTimeCount() + " secs");
	};
}