package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;
import static org.chocosolver.solver.search.strategy.Search.minDomLBSearch;
import java.io.IOException;

public class tsp_aula_rank {
	
	public static void main(String[] args) throws IOException {
		
		int [][] dist = { // the adjacency graph of the problem
			{   0, 107, 241, 190, 124,  80, 316,  76, 152, 157, 283, 133, 113, 297, 228},
			{ 107,   0, 148, 137,  88, 127, 336, 183, 134,  95, 254, 180, 101, 234, 175},
			{ 241, 148,   0, 374, 171, 259, 509, 317, 217, 232, 491, 312, 280, 391, 412},
			{ 190, 137, 374,   0, 202, 234, 222, 192, 248,  42, 117, 287,  79, 107,  38},
			{ 124,  88, 171, 202,   0,  61, 392, 202,  46, 160, 319, 112, 163, 322, 240},
			{  80, 127, 259, 234,  61,   0, 386, 141,  72, 167, 351,  55, 157, 331, 272},
			{ 316, 336, 509, 222, 392, 386,   0, 233, 438, 254, 202, 439, 235, 254, 210},
			{  76, 183, 317, 192, 202, 141, 233,   0, 213, 188, 272, 193, 131, 302, 233},
			{ 152, 134, 217, 248,  46,  72, 438, 213,   0, 206, 365,  89, 209, 368, 286},
			{ 157,  95, 232,  42, 160, 167, 254, 188, 206,   0, 159, 22,   57, 149,  80},
			{ 283, 254, 491, 117, 319, 351, 202, 272, 365, 159,   0, 404, 176, 106,  79},
			{ 133, 180, 312, 287, 112,  55, 439, 193,  89, 220, 404,   0, 210, 384, 325},
			{ 113, 101, 280,  79, 163, 157, 235, 131, 209,  57, 176, 210,   0, 186, 117},
			{ 297, 234, 391, 107, 322, 331, 254, 302, 368, 149, 106, 384, 186,   0,  69},
			{ 228, 175, 412,  38, 240, 272, 210, 233, 286,  80,  79, 325, 117,  69,   0}
		};
		
		int n = 10;			// restricts the graph to the first n nodes (n <= 15)
		int max_dist = 800;	// a safe maximum distance between two nodes
		
		// the adjacency matrix of the working graph
		int [][] d = new int [n][n];	 
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++)
				d[i][j] = dist[i][j];
		
		// the flattened adjacency matrix of the graph: flat[i*n+j] = d[i][j]
		// required for the element constraint below
		int [] flat = new int[n*n];
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++)
				flat[n*i+j] = dist[i][j];
		
		 /* flat[i*n+j] = d[i][j]				
					9 7 3
			d = 	2 4 1 				d[2][1] = 5 
					8 5 6
				
			flat =	9 7 3 2 4 1 8 5 6	flat[2*3+1] = flat[7] = 5
		 */
		
		Model md = new Model(" TSP ");
		Solver sv = md.getSolver();
		
		// Decision vector representing the rank of each node in the circuit
		// rank = [ 2 4 1 0 3] => circuit = 2->4->1->0->3->2
		IntVar [] rank = md.intVarArray("rank", n, 0, n-1);
		
		// A solution is a permutation of the nodes
		md.allDifferent(rank).post();
		
		// The circuit starts in node 0 - Symmetry breaking
		//md.arithm(rank[0], "=", 0);		
		
		// Set the circuit direction - Symmetry breaking:
		// The node leading to 0 is less than the node after 0
		//md.arithm(rank[1], "<", rank[n-1]);			
		
		// rk_2 is the linear conversion of indices i,j in the distance matrix
		// rk_2[i] =rank[i]*n + rank[i+1] (note: rk_2[n-1] =rank[n-1]*n + rank[0]
		IntVar [] rk_2 = md.intVarArray("K", n, 0, (n*n)-1);
		for (int i = 0; i < n-1; i++) rk_2[i].eq((rank[i].mul(n)).add(rank[i+1])).post();
		rk_2[n-1].eq((rank[n-1].mul(n)).add(rank[0])).post();	

		// cost[i] denotes the distance of the arc leaving node i
		IntVar [] cost = md.intVarArray("cost", n, 0, max_dist);
		
		// cost[i] = d[rank[i]][rank[i+1]] = flat[rk_2[i]]
		for (int i = 0; i < n; i++) md.element(cost[i], flat, rk_2[i], 0).post();
		
		// total_cost is the sum of all costs
		IntVar tot_cost = md.intVar(0, n*max_dist);	
		md.sum(cost, "=", tot_cost).post();
	
		// minimise an objective function; here is the total cost
		md.setObjective(Model.MINIMIZE, tot_cost);	
		
		// heuristic search: prefer
		//    variables with less values in their domain
		//    assign them, their lower bounds
		sv.setSearch(minDomLBSearch(rank));	
		
		// set search interruption parameters
		// int backLimit = 1000; sv.limitBacktrack(1000);
		// int solLimit = 3; sv.limitSolution(solLimit);
		// int timeLimit = 120000; sv.limitTime(timeLimit);
		
		while (sv.solve()){
			System.out.print("\n -- solution " + sv.getSolutionCount() + "\t= " + tot_cost.getValue());
			System.out.println(" found after " + sv.getTimeCount() + " secs");
			for(int i = 0; i< n; i++) System.out.print(" " + rank[i].getValue()); System.out.println();
			//for(int i = 0; i< n; i++) System.out.print(" " + rk_2[i].getValue()); System.out.println();
			//for(int i = 0; i< n; i++) System.out.print(" " + cost[i].getValue()); System.out.println();
		}
		System.out.print( "\n !!! No (more) solutions");
		System.out.println(" after " + sv.getTimeCount() + " secs");
	};
}