package choco;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.IntVar;

public class job_shop_no_tasks {

	public static void main(String[] args) {
				

		int [][] durs = {{2,4,7},{3,4,5},{5,3,3},{3,4,4}};
		int [][] mchs = {{0,1,2},{2,1,0},{0,1,2},{1,2,0}};
		int max_time = 30; // last time a task may start
/*		
		int [][] durs = {
				{21, 53, 95, 55, 34},
				{21, 52, 16, 26, 71},
				{39, 98, 42, 31, 12},
				{77, 55, 79, 66, 77},
				{83, 34, 64, 19, 37},
				{54, 43, 79, 92, 62},
				{69, 77, 87, 87, 93},
				{38, 60, 41, 24, 83},
				{17, 49, 25, 44, 98},
				{77, 79, 43, 75, 96}
			};
			
			
			int [][] mchs = {
				{1, 0, 4, 3, 2}, 
				{0, 3, 4, 2, 1}, 
				{3, 4, 1, 2, 0}, 
				{1, 0, 4, 2, 3}, 
				{0, 3, 2, 1, 4}, 
				{1, 2, 4, 0, 3}, 
				{3, 4, 1, 2, 0}, 
				{2, 0, 1, 3, 4}, 
				{3, 1, 4, 0, 2}, 
				{4, 3, 2, 1, 0}
			};
		int max_time = 1000; // last time a task may start		
*/		
		int njobs = durs.length;
		int ntsks = durs[0].length;
		int nmchs = ntsks;		

		boolean cumul = false;
		// int backLimit = 1000; sv.limitBacktrack(1000);
		// int solLimit = 3; sv.limitSolution(solLimit);
		// int timeLimit = 120000; sv.limitTime(timeLimit);
		
		Model md = new Model("(" + njobs +"," + ntsks + ") - Job Shop");
		Solver sv = md.getSolver();

		// beginning and ending of the tasks
		IntVar [][] begs = md.intVarMatrix("Starts", njobs, ntsks, 0, max_time);
		IntVar [][] ends = md.intVarMatrix("Starts", njobs, ntsks, 0, max_time);
		
		// constraining beginning and ending decision variables
		for (int i = 0; i < njobs; i++)
			for (int j = 0; j < ntsks; j++)
				md.arithm(ends[i][j], "=", begs[i][j], "+", durs[i][j]).post();
		
		// precedence constraints between tasks of the same job
		for (int i = 0; i < njobs; i++)
			for (int j = 0; j < ntsks-1; j++)
				md.arithm(begs[i][j+1], ">=", ends[i][j]).post();
		if (cumul) {
			IntVar [][] mxbegs = md.intVarMatrix("Starts", nmchs, njobs, 0, max_time);
			int [][] mxdurs = new int [nmchs][njobs];
			int [] ones = new int [njobs];
			for (int m = 0; m < nmchs; m++){
				int p = 0;
				for (int i = 0; i < njobs; i++){
					ones[i] = 1;
					for (int j = 0; j < nmchs; j++){
						if (mchs[i][j] == m){
							mxbegs[m][p] = begs[i][j];
							mxdurs[m][p] = durs[i][j];
							p = p + 1;
						}
					}
				}
				md.cumulative(mxbegs[m], mxdurs[m], ones, 1);			}				
		} else {
		// disjunctive constraints on tasks sharing the same machine
			for (int i1 = 0; i1 < njobs-1; i1++)
				for (int i2 = i1+1; i2 < njobs; i2++)
					for (int j1 = 0; j1 < ntsks; j1++)
						for (int j2 = 0; j2 < ntsks; j2++)
							if (mchs[i1][j1] == mchs[i2][j2])
								md.or(
									md.arithm(ends[i1][j1],"<=", begs[i2][j2]),
									md.arithm(ends[i2][j2],"<=", begs[i1][j1])
							).post();
		}
		// set objective on the last task to end
		IntVar [] lx = md.intVarArray(njobs,1,max_time);
		IntVar last = md.intVar(1,max_time);
		for (int i = 0; i < njobs; i++)
			lx[i] = ends[i][ntsks-1];
		md.max(last, lx).post();
		md.setObjective(Model.MINIMIZE, last);	
		
		while (sv.solve()){
			System.out.print("\nSolving " + sv.getModelName() + " (solution " + sv.getSolutionCount() + ");");
			System.out.print(" with Makespan = " + last.getValue());
			System.out.println(" in " + sv.getTimeCount() + " secs");
		/*
			System.out.println("--- Jobs ---");
			for (int i = 0; i< njobs; i++){
				for (int j = 0; j< ntsks; j++)
					System.out.print(" " + begs[i][j].getValue() + " to " + ends[i][j].getValue() +"; ");
				System.out.println();
			}
			System.out.println();
			
			System.out.println("--- Machines ---");
			for(int m = 0; m < nmchs; m++){
				for (int i = 0; i < njobs; i++)
					for (int j = 0; j < ntsks; j++)
						if (mchs[i][j] == m)
							System.out.print(" " + begs[i][j].getValue() + " to " + ends[i][j].getValue() +"; ");
				System.out.println();
			}	
		*/
		}
		System.out.println("\n !!! No (more) solutions after " + sv.getTimeCount() + " secs");
	}
}
