package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;

public class job_shop_with_tasks {

	public static void main(String[] args) {
				
		int [][] durs = {{2,4,7},{3,4,5},{5,3,3},{3,4,4}};
		int [][] mchs = {{0,1,2},{2,1,0},{0,1,2},{1,2,0}};
		int max_time = 30; // last time a task may start
/*		
		int [][] durs = {
				{21, 53, 95, 55, 34},
				{21, 52, 16, 26, 71},
				{39, 98, 42, 31, 12},
				{77, 55, 79, 66, 77},
				{83, 34, 64, 19, 37},
				{54, 43, 79, 92, 62},
				{69, 77, 87, 87, 93},
				{38, 60, 41, 24, 83},
				{17, 49, 25, 44, 98},
				{77, 79, 43, 75, 96}
			};
			
			
			int [][] mchs = {
				{1, 0, 4, 3, 2}, 
				{0, 3, 4, 2, 1}, 
				{3, 4, 1, 2, 0}, 
				{1, 0, 4, 2, 3}, 
				{0, 3, 2, 1, 4}, 
				{1, 2, 4, 0, 3}, 
				{3, 4, 1, 2, 0}, 
				{2, 0, 1, 3, 4}, 
				{3, 1, 4, 0, 2}, 
				{4, 3, 2, 1, 0}
			};
		int max_time = 1000; // last time a task may start		
*/		
		int njobs = durs.length;
		int ntsks = durs[0].length;
		int nmchs = ntsks;
		
		Model md = new Model("(" + njobs +"," + ntsks + ") - Job Shop");
		Solver sv = md.getSolver();
		
		// int backLimit = 1000; sv.limitBacktrack(1000);
		int solLimit = 3; sv.limitSolution(solLimit);
		// int timeLimit = 120000; sv.limitTime(timeLimit);
		
		// beginning and end of the tasks
		IntVar [][] begs = md.intVarMatrix("Starts", njobs, ntsks, 0, max_time);
		IntVar [][] ends = md.intVarMatrix("Starts", njobs, ntsks, 0, max_time);

		// Specification of the tasks (per machine)
		Task [][] tx = new Task[nmchs][njobs];
		for (int m = 0; m < nmchs; m++){
			int p = 0;
			for(int i = 0; i < njobs; i++){
				for (int j = 0; j < ntsks; j++){
					if(mchs[i][j] == m){
						tx[m][p] = new Task(begs[i][j], md.intVar(durs[i][j],durs[i][j]), ends[i][j]);
						p = p + 1;
					}
				}
			}
		}
				
		// precedence constraints between tasks of the same job
		for (int i = 0; i < njobs; i++)
			for (int j = 0; j < ntsks-1; j++)
				md.arithm(begs[i][j+1], ">=", ends[i][j]).post();
		
		// no overload of machines		
		Cumulative.Filter cum = Cumulative.Filter.SWEEP; //TIME, SWEEP, ...
		boolean graphBased = true;
		IntVar one = md.intVar(1,1);
		IntVar [] ones = md.intVarArray(njobs,1,1);
		for (int m = 0; m < nmchs; m++) 
			md.cumulative(tx[m], ones, one, graphBased, cum).post();

		
		// set objective on the last task to end
		IntVar [] lx = md.intVarArray(njobs,1,max_time);
		IntVar last = md.intVar(1,max_time);
		for (int i = 0; i < njobs; i++)
			md.arithm(lx[i], "=", begs[i][ntsks-1], "+", durs[i][ntsks-1]).post();
		md.max(last, lx).post();
		md.setObjective(Model.MINIMIZE, last);	
				
		while (sv.solve()){
			System.out.print("\nSolving " + sv.getModelName() + " (solution " + sv.getSolutionCount() + ");");
			System.out.print(" with Makespan = " + last.getValue());
			System.out.println(" in " + sv.getTimeCount() + " secs");
		
			System.out.println("--- Jobs ---");
			for (int i = 0; i< njobs; i++){
				for (int j = 0; j< ntsks; j++)
					System.out.print(" " + begs[i][j].getValue() + " to " + ends[i][j].getValue() +"; ");
				System.out.println();
			}
			System.out.println();
			
			System.out.println("--- Machines ---");
			for(int m = 0; m < nmchs; m++){
				for (int i = 0; i < njobs; i++)
					for (int j = 0; j < ntsks; j++)
						if (mchs[i][j] == m)
							System.out.print(" " + begs[i][j].getValue() + " to " + ends[i][j].getValue() +"; ");
				System.out.println();
			}	
		
		}
		System.out.println("\n !!! No (more) solutions after " + sv.getTimeCount() + " secs");
	}
}
