package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.*;
import org.chocosolver.solver.exception.ContradictionException;

public class alldiff_regin {
	public static void main(String[] args) throws ContradictionException {
		Model md = new Model("All Diff Demo");
		Solver sv = md.getSolver();
		
		IntVar a = md.intVar(new int[] {1,2});
		IntVar b = md.intVar(new int[] {1,2});
		IntVar c = md.intVar(1,3,true);
		IntVar d = md.intVar(2,5,true);
		IntVar e = md.intVar(3,6,true);		
		
		//IntVar [] X = {a,b,c,d,e};
		IntVar [] X = {};
		X = ArrayUtils.concat(X,a);
		X = ArrayUtils.concat(X,b);
		X = ArrayUtils.concat(X,c);
		X = ArrayUtils.concat(X,d);
		X = ArrayUtils.concat(X,e);
		
		String cons_level = "AC";            // "DEFAULT", "AC", "BC", "FC"
		md.allDifferent(X,cons_level).post();
		sv.propagate();

		
		for (int i = 0; i < 5; i++){
			System.out.print(String.valueOf(i) + " (" + X[i].getDomainSize() + "): ");
			for (int j = 1; j < 7; j++){
				if (X[i].contains(j)) {
					System.out.print(" " + j);
				}
			}
		System.out.println();
		}
	};
}
