package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;


public class alldiff_triples {
	public static void main(String[] args) throws ContradictionException {
		Model model = new Model("All Diff Demo");
		Solver s = model.getSolver();
		String cons_level = "DEFAULT";            // "DEFAULT", "AC", "BC", "FC"
		
		IntVar [] x = model.intVarArray("X", 9, 1, 9);                 // x in 1..9

		for (int i = 0; i < 3; i++){
			model.arithm(x[i], ">=", 3).post(); // x[i] in 2..4
			model.arithm(x[i], "<=", 5).post(); // 
		}

		for (int i = 3; i < 6; i++){
			model.arithm(x[i], ">=", 3).post(); // x[i] in 6..6
			model.arithm(x[i], "<=", 8).post(); // x[0] in 1..2
		}

		model.allDifferent(x,cons_level).post();
		
		s.propagate();
		
		for (int i = 0; i < 9; i++){
			System.out.print(String.valueOf(i) + " (" + x[i].getDomainSize() + "): ");
			for (int j = 1; j <= 9; j++){
				if (x[i].contains(j)) {
					System.out.print(" " + j);
				}
			}
		System.out.println("");
		}
	};
}
