package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;

public class nurses {
	
	public static void main(String[] args) throws ContradictionException {

		// A team of 7 nurses (a to g) must ensure: 
		// 	one or two must be assigned the morning shift (1),
		// 	one or two the afternoon shift (2);
		// 	one the night shift (3);
		// 	while the others may be on holliday (4) or stay in reserve (5). 
		
		Model md = new Model(" TSP ");
		Solver sv = md.getSolver();
		
		int ns = 5;
		IntVar c0 = md.intVar(1,2);
		IntVar c1 = md.intVar(1,2);
		IntVar c2 = md.intVar(1,1);
		IntVar c3 = md.intVar(0,5);
		IntVar c4 = md.intVar(0,5);
		IntVar [] shifts = {c0,c1,c2,c3,c4};
		
		IntVar a = md.intVar(0,1);
		IntVar b = md.intVar(0,1);
		IntVar c = md.intVar(0,1);
		IntVar d = md.intVar(0,1);
		IntVar e = md.intVar(0,2);
		IntVar f = md.intVar(1,4);
		IntVar g = md.intVar(new int[] {2,4});
		
		IntVar [] nurses = {a,b,c,d,e,f,g};
		
		for (int i = 0; i < ns; i++)  md.count(i, nurses, shifts[i]).post();
		
		md.globalCardinality(nurses, new int[] {0,1,2,3,4}, shifts, false).post();
		
		
		sv.propagate();
		//if (sv.solve()){
			for (int i = 0; i < 7; i++){
				System.out.print("nurse " + String.valueOf(i) + " (" + 
										nurses[i].getDomainSize() + "): ");
				for (int j = 0; j < 5; j++){
					if (nurses[i].contains(j)) {
						System.out.print(" " + j);
					}
				}
				System.out.println();
			}
			System.out.println('\n');
		//}
	}
}
	