package choco;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.Solver;
import org.chocosolver.util.tools.*;

public class tsp_0 {
	
	public static void main(String[] args) {

		int [][] dist = {{0,5,9,0},{3,2,5,8},{4,0,2,7},{0,6,9,0}};
		int n = dist.length;
		
		Model md = new Model(" TSP ");
		Solver s = md.getSolver();
		IntVar [] next = {};
		
		//create the variables and domains
		for (int i = 0; i < n; i++){
			int [] dom = create_domain(dist[i]);
			for(int j = 0; j < dom.length; j++)
				System.out.print(" " + dom[j]);
			System.out.println();
			IntVar one = md.intVar(dom);
			next = ArrayUtils.concat(next,one);
		}
		System.out.println();

		md.circuit(next).post();
		int k = 0;
		while (s.solve()){
			k = k + 1;
			System.out.print(" Solution " + k + ": ");
			for(int i = 0; i< n; i++) {
				System.out.print(" " + next[i].getValue()); 
			}
			System.out.println();
		}
		System.out.print( "\n !!! No (more) solutions");
		System.out.println();
	}
	
	public static int [] create_domain(int [] d){
		int [] dom = {};
		int n = d.length;
		for (int i = 0; i < n; i++){
			if (d[i] > 0){
				//System.out.println( "i = " + i + " and d[i] = " + d[i]);
				int m = dom.length;
				//System.out.println( "m = " + m);
				int [] dom_x = new int[m + 1];
				for (int j = 0; j < m; j++){
					dom_x [j] = dom[j];
				}
				//System.out.println( "last to assign = " + (m+1));
				//System.out.println( "length of dom_x = " + dom_x.length);
				dom_x[m] = i;
				dom = dom_x;
			}
			//System.out.println( "new len of dom = " + dom.length);
		}
		return dom;
	};
}
	