package choco;

import java.io.IOException;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;


public class job_shop_file {

	public static void main(String[] args)  throws IOException {
		jobs js = new jobs();
		js.ReadJobs("jobshop/js_abz09.txt");

		int njobs = js.nj;
		int ntsks = js.nt;
		int nmchs = ntsks;
		int [][] tasks = js.tasks;
		int [][] machs = js.machs;
		
		// search options
		boolean cumul = true;
		
		Model md = new Model("(" + 4 +"," + 3 + ") - Job Shop");
		Solver sv = md.getSolver();
		
		int solLimit = 100; sv.limitSolution(solLimit);
		int maxDuration = 50;

		int maxSpan = ntsks*ntsks* maxDuration;
		int maxStrt = maxSpan;	
		
		Task [][] tx = new Task[njobs][ntsks];
		for(int i = 0; i < njobs; i++){
			for (int j = 0; j < ntsks; j++){
				tx[i][j] = new Task(md.intVar(1,maxStrt), md.intVar(tasks[i][j],tasks[i][j]), md.intVar(1, maxSpan));
			}
		}

		Task [][] mx = new Task[nmchs][njobs];
		for (int k = 0; k < nmchs; k++){
			int p = 0;
			for(int i = 0; i < njobs; i++){
				for (int j = 0; j < ntsks; j++){
					if(machs[i][j] == k){
						mx[k][p] = tx[i][j];
						p = p + 1;
					}
				}
			}			
		}

		// precedence constraints
		for (int i = 0; i < njobs; i++) {
			for (int j = 0; j < ntsks-1; j++) {
				md.arithm(tx[i][j].getEnd(), "<=", tx[i][j+1].getStart()).post();
			}
		}

		// set objective 
		IntVar [] lx = md.intVarArray(njobs,1,maxSpan);
		IntVar last = md.intVar(1,maxSpan);
		for (int i = 0; i < njobs; i++)
			lx[i] = tx[i][ntsks-1].getEnd();
		md.max(last, lx).post();
		md.setObjective(Model.MINIMIZE, last);	
		
		if (cumul){
			Cumulative.Filter cum = Cumulative.Filter.SWEEP; //TIME, SWEEP, ...
			boolean graphBased = true;
			IntVar one = md.intVar(1,1);
			IntVar [] ones = md.intVarArray(njobs,1,1);
			for (int k = 0; k < nmchs; k++)
				md.cumulative(mx[k], ones, one, graphBased, cum).post();
		} else {
			for (int k = 0; k < nmchs; k++) {
				for (int i = 0; i < mx[k].length-1; i++) {
					for (int j = i+1; j < mx[k].length; j++) {
						md.or(
							md.arithm(mx[k][i].getEnd(), "<", mx[k][j].getStart()),
							md.arithm(mx[k][j].getEnd(), "<", mx[k][i].getStart())
						).post();
					}
				}
			}
		}
		
		if (sv.solve()){
			System.out.print("Solving " + sv.getModelName() + " (solution " + sv.getSolutionCount() + ");");
			System.out.println(" with Makespan = " + last.getValue());
			System.out.println("--- Jobs ---");
			for(int i = 0; i< njobs; i++){	
				for (int j = 0; j< ntsks; j++) {
					System.out.print(" " + tx[i][j].getStart().getValue() + " to " + tx[i][j].getEnd().getValue()+"; ");
				}
				System.out.println();
			}
			System.out.println();
			System.out.println("--- Machines ---");
			for(int i = 0; i< nmchs; i++){	
				for (int j = 0; j< ntsks; j++) {
					System.out.print(" " + mx[i][j].getStart().getValue() + " to " + mx[i][j].getEnd().getValue()+"; ");
				}
				System.out.println();
			}
		}
		System.out.println("\n !!! No (more) solutions after " + sv.getTimeCount() + " secs");
	}
}	
