package choco;

import java.io.IOException;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.IntVar;

public class tiling_rectangles {

	public static void main(String[] args) throws IOException {
		rectangle r = new rectangle();
		r.Read("rectangles/doze.txt");
		int n = r.n;

		// search options		
		int mode = 3; //1-fixed; 2-rotate; 3-reshape
		boolean difn = true;
		
		Model md = new Model(n + " - Filling ");
		System.out.println(r.n + " rectangles to fill " + r.maxW + " x " + r.maxH);
		Solver sv = md.getSolver();
		int solLimit = 100; sv.limitSolution(solLimit);
		
		IntVar [] x = md.intVarArray("X",n,1,r.maxW);
		IntVar [] y = md.intVarArray("Y",n,1,r.maxH);
		 
		IntVar [] w = md.intVarArray("W",n,1,10);
		IntVar [] h = md.intVarArray("H",n,1,10);
		
		for (int i = 0; i < n; i++) {
			if (mode == 1){
				md.arithm(w[i], "=", r.ww[i]).post();
				md.arithm(h[i], "=", r.hh[i]).post();
			} else if (mode == 2){
				md.or(md.arithm(w[i],"=",r.ww[i]),
					  md.arithm(w[i],"=",r.hh[i]))
					 .post();
				md.or(md.arithm(w[i],"*",h[i],"=",r.ww[i]*r.hh[i])).post();
			} else {
				md.arithm(w[i], "*", h[i] , "=", r.ww[i]*r.hh[i]).post();
			}
		}
			
		for (int i = 0; i < n; i++) {
			md.arithm(x[i], "+", w[i] , "<=", r.maxW+1).post();
			md.arithm(y[i], "+", h[i] , "<=", r.maxH+1).post();
		}
		
		if (difn) {
			md.diffN(x,y, w, h, true).post();
		} else {
			for (int i = 0; i < n-1; i++) {
				for (int j = i+1; j < n; j++) {
					md.or(
							md.arithm(x[i], "+", w[i], "<=", x[j]),
							md.arithm(x[j], "+", w[j], "<=", x[i]),
							md.arithm(y[i], "+", h[i], "<=", y[j]),
							md.arithm(y[j], "+", h[j], "<=", y[i])
						 ).post();
				}
			}
		}

		while (sv.solve()){
			System.out.println("\n -- solution " + sv.getSolutionCount() + " :");
			for(int i = 0; i< n; i++) System.out.print(" " + w[i].getValue()); System.out.println();
			for(int i = 0; i< n; i++) System.out.print(" " + h[i].getValue()); System.out.println();			
			//System.out.println(" - found after " + sv.getTimeCount() + " secs");
			for(int i = 0; i< n; i++) System.out.print(" " + x[i].getValue()); System.out.println( " <= " + r.maxW);
			for(int i = 0; i< n; i++) System.out.print(" " + y[i].getValue()); System.out.println( " <= " + r.maxH);
			//System.out.println();
			//for(int i = 0; i< n; i++) System.out.print(" " + (x[i].getValue()+w[i].getValue())); System.out.println( " <= " + (r.maxW+1));
			//for(int i = 0; i< n; i++) System.out.print(" " + (y[i].getValue()+h[i].getValue())); System.out.println( " <= " + (r.maxH+1));
		}
		System.out.print( "\n No (more) solutions found after " + sv.getTimeCount() + " secs");
			
		//if (s.getTimeCount() > timeLimit/1000) 
		//	System.out.print( " after time limit of " + timeLimit/1000 + " secs");
		//System.out.println('\n');
		//s.printStatistics();
	}
}	